﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>

namespace nnt { namespace nd {

//! 受信時刻以外の内容を比較して一致を判定する。
bool AreEqualNeighborInfoForSystemExceptReceviedTimePoint(const nn::nd::NeighborInfoForSystem& lhs, const nn::nd::NeighborInfoForSystem& rhs) NN_NOEXCEPT;

//! index のアカウントを取得する。その index のアカウントがいなければ false を返す。
bool GetAccountUid(nn::account::Uid* pOut, int index) NN_NOEXCEPT;

//! スレッドで実行する。スタックは 8 KiB、優先度は os::DefaultThreadPriority で固定。
int RunOnThread(void(*f)(void*), void* arg) NN_NOEXCEPT;
void DestroyThread(int i) NN_NOEXCEPT;

//! 中身をランダムに埋めた NeighborInfoForSystem を生成する。
void MakeDummyNeighborInfoForsystemWithRandomData(nn::nd::NeighborInfoForSystem* pOut) NN_NOEXCEPT;

//! NeighborInfoForSystem をログに出力する。
void DumpNeighborInfoForSystem(const nn::nd::NeighborInfoForSystem& info) NN_NOEXCEPT;

}} // ~nnt::nd
