﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**

 */

#include <nn/os.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <cstdio>

const size_t HeapSize  = 256 * 1024 * 1024;
const size_t BlockSize = 16 * 1024 * 1024;

extern "C" void nninitStartup()
{
    NN_ASSERT(nn::os::SetMemoryHeapSize(HeapSize).IsSuccess(), "SetMemoryHeapSize failed.\n");

    uintptr_t address;
    nn::Result result = nn::os::AllocateMemoryBlock(&address, BlockSize);
    NN_ASSERT(result.IsSuccess());
    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), BlockSize);
}


void X();       //<-- fails to get linker/loader error if build with Link            //

extern "C" void nnMain()
{
    X();
    printf("Hello World\n");
}
