﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/




#include <cstdlib>
#include <mm_MemoryManagement.h>
#include <nnt/nntest.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/init.h>
#include <cstdio>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <nv/nv_MemoryManagement.h>
#include <cerrno>
#include "sri.h"


#if 1

namespace{

    const int FsHeapSize = 512 * 1024;

    uint8_t              g_FsHeapBuffer[FsHeapSize];
    nn::lmem::HeapHandle g_FsHeap;

    void FsInitHeap()
    {
        g_FsHeap = nn::lmem::CreateExpHeap(g_FsHeapBuffer, FsHeapSize, nn::lmem::CreationOption_DebugFill);
    }

    void* FsAllocate(size_t size)
    {
        return nn::lmem::AllocateFromExpHeap(g_FsHeap, size);
    }

    void FsDeallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
            return nn::lmem::FreeToExpHeap(g_FsHeap, p);
    }

}

namespace // 'unnamed'
{
nn::mem::StandardAllocator g_MultimediaAllocator;
}

void MMCreateAllocator()
{
    const int allocatorSize = 512 << 20;
    static char s_MMAllocatorBuffer[allocatorSize];
    g_MultimediaAllocator.Initialize(s_MMAllocatorBuffer, sizeof(s_MMAllocatorBuffer));
}

void MMDestroyAllocator()
{
    g_MultimediaAllocator.Finalize();
}

void *MMAlloc(size_t size, size_t alignment, void*)
{
    return g_MultimediaAllocator.Allocate(size, alignment);
}

void MMFree(void *p, void*)
{
    g_MultimediaAllocator.Free(p);
}

void *MMRealloc(void *p, size_t newSize, void*)
{
    return g_MultimediaAllocator.Reallocate(p, newSize);
}

//----------------------------------------------------------
// nninitStartup() is invoked before calling nnMain().
//----------------------------------------------------------

extern "C" void nninitStartup()
{
    #if 1
    const size_t heapSize = 128 << 20;
    const size_t mallocSize = 32 << 20;
    uintptr_t address;
    nn::Result result;

    result = nn::os::SetMemoryHeapSize(heapSize);
    //ASSERT(result.IsSuccess());

    result = nn::os::AllocateMemoryBlock(&address, mallocSize);
    //ASSERT(result.IsSuccess());

    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), mallocSize);
    FsInitHeap();
    nn::fs::SetAllocator(FsAllocate, FsDeallocate);
    //NN_SDK_LOG("\ninit done: \n");
    #endif
}


static void displayUsage()
{
    NN_SDK_LOG("Usage: SRI Image sample [COMMAND] ...\n"
    "  screenshot  --out <OutputFile>                                                Capture screenshot and save compressed image in output file\n"
    "  input --in <InputFile> -width<Width> -height<Height>  --out <OutputFile>      Compress input file raw data in to JPEG output file \n"
    "  help                                                                          Print this help message\n"
    );
}

int readFile(const char* path, Buffer* pRawBuffer){
    nn::fs::FileHandle fileHandle;
    int64_t fileSize = 0;
    NN_ABORT_UNLESS(
        nn::fs::OpenFile(&fileHandle, path, nn::fs::OpenMode_Read).IsSuccess() && // ファイルのオープンに失敗
        nn::fs::GetFileSize(&fileSize, fileHandle).IsSuccess() && // ファイルのサイズ取得に失敗
        fileSize <= 0xFFFFFFFF); // ファイルが大きすぎる。
    pRawBuffer->size = static_cast<size_t>(fileSize);
    pRawBuffer->pData = (uint8_t*)malloc(pRawBuffer->size);
    NN_ABORT_UNLESS(
        pRawBuffer->pData != nullptr &&
        nn::fs::ReadFile(fileHandle, 0, pRawBuffer->pData, pRawBuffer->size ).IsSuccess());
    nn::fs::CloseFile(fileHandle);
    return 0;
}


int save(const char* path, Buffer* ImageBuffer){

    nn::Result result;
    nn::fs::FileHandle fileHandle;
    //nn::fs::WriteOption option;

    nn::fs::CreateFile(path, ImageBuffer->size).IsSuccess();

    result = nn::fs::OpenFile(&fileHandle, path, nn::fs::OpenMode_Write);
    NN_ASSERT(result.IsSuccess());
    result = nn::fs::WriteFile(fileHandle, 0, ImageBuffer->pData, ImageBuffer->size, nn::fs::WriteOption::MakeValue(nn::fs::WriteOptionFlag_Flush));
    NN_SDK_LOG("%s:%d result = 0x%x, size = %d \n", __func__, __LINE__, result, ImageBuffer->size);
    nn::fs::CloseFile(fileHandle);
    return 0;
}
void verifyState(SriState state)
{
    switch(state)
    {
        case SriState_UnInitialized:
            NN_SDK_LOG("SriState_UnInitialized\n\n");
            break;
        case SriState_Initialized:
            NN_SDK_LOG("SriState_Initialized\n\n");
            break;
        case SriState_Ready:
            NN_SDK_LOG("SriState_Ready\n\n");
            break;
        case SriState_Error:
            NN_SDK_LOG("SriState_Error\n\n");
            break;
        default:
            break;
    }

}
/* Process main entry */
TEST(SriImageTest, Image)
{
    MMCreateAllocator();
    NN_SDK_LOG("Calling nv::mm::SetAllocator\n");
    nv::mm::SetAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    NN_SDK_LOG("Calling nv::SetGraphicsAllocator\n");
    nv::SetGraphicsAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    NN_SDK_LOG("Calling nv::SetGraphicsDevtoolsAllocator\n");
    nv::SetGraphicsDevtoolsAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    const int mmFirmwareMemorySize = 8 << 20;
    NN_ALIGNAS(4096) static char s_mmFirmwareMemory[mmFirmwareMemorySize];
    NN_SDK_LOG("Calling nv::InitializeGraphics\n");
    nv::InitializeGraphics(s_mmFirmwareMemory, sizeof(s_mmFirmwareMemory));
    int argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();
    const char* inputFileName = 0;
    const char *outFilePath = 0;
    bool screenShot;
    SriConfig config;
    ImageInfo pImageInfo;
    Buffer pRawBuffer;
    Buffer pImageBuffer;
    ImageInfo pJpegInfo;
    //float BytesPerPixel;
    uint32_t width = 0, height = 0;
    SriState state;
    nn::Result result;
    movie::Status movieStatus = movie::Status_Success;

    if (strcmp(argv[1], "screenshot") == 0){
        screenShot = true;
    }
    else if (strcmp(argv[1], "input") == 0){
        screenShot = false;

    }else if (strcmp(argv[1], "help") == 0 ||
        strcmp(argv[1], "-h") == 0 ||
        strcmp(argv[1], "--help") == 0)
        {
            displayUsage();
            return ;
        }
    else{
        displayUsage();
        return ;

    }


    for (int i = 2; i < argc; i++)
    {
        if(argc - i < 2)
            break;
        if (!screenShot){
            if (!strcmp(argv[i], "-width"))
            width = atoi(argv[++i]);
            else if(!strcmp(argv[i], "-height"))
                height = atoi(argv[++i]);
            else if(!strcmp(argv[i], "--in"))
                inputFileName = argv[++i];
            else if(!strcmp(argv[i], "--out"))
                outFilePath = argv[++i];
            else
            {
                displayUsage();
                return;
            }

        }
        else{

            if(!strcmp(argv[i], "--out"))
                outFilePath = argv[++i];
            else
            {
                displayUsage();
                return;
            }
        }

    }
    if(screenShot){
        if(!outFilePath)
        {
            displayUsage();
            return;
        }
    }
    else
    {
        if(!width || !height || !outFilePath || !inputFileName)
        {
            displayUsage();
            return;
        }
    }

    bool sdcardMounted = false;
    const char* token = "sdcard";
    int compare;
    if(screenShot)
        compare = strncmp(outFilePath, token, strlen(token));
    else
        compare = strncmp(inputFileName, token, strlen(token));
    if (compare == 0)
    {
        nn::Result resultSdcardMount = nn::fs::MountSdCardForDebug("sdcard");
        if (resultSdcardMount.IsFailure())
        {
            NN_SDK_LOG("nn::fs::SD card Mount failure. Module:%d, Description:%d\n",
                    resultSdcardMount.GetModule(),
                    resultSdcardMount.GetDescription());
            return;
        }
        sdcardMounted = true;
    }
    else
    {
        nn::Result resultHostMount = nn::fs::MountHostRoot();
        if (resultHostMount.IsFailure())
        {
            NN_SDK_LOG("nn::fs::Host root mount failure.\n",
                    resultHostMount.GetModule(),
                    resultHostMount.GetDescription());
            return;
        }

    }
    movie::recorder::SRI* sri = NULL;
    movie::recorder::SRI::Create(&sri);
    if( sri != NULL )
    {
        config.returnJPEG = true;
        if (screenShot)
            config.getRawFrameFromClient = false;
        else
            config.getRawFrameFromClient = true;

        /****************************Prepare for thumbnail output**************************************/
        config.returnThumbnail = true; //to test error case
        movieStatus = sri->Prepare(&config);

        sri->GetState(&state);
        NN_SDK_LOG("State after Prepare is ");
        verifyState(state);
        /****************************Reset**************************************/
        sri->Reset();
        NN_SDK_LOG("Reset is done\n");

        sri->GetState(&state);
        NN_SDK_LOG("State after Reset is ");
        verifyState(state);

        /****************************Prepare**************************************/
        config.returnThumbnail = false;
        movieStatus = sri->Prepare(&config);
        if (movieStatus != movie::Status_Success)
            NN_SDK_LOG(" ******Prepare failed*******\n");
        NN_SDK_LOG("*****Prepare for o/p jpeg is ready*****\n");

        sri->GetState(&state);
        NN_SDK_LOG("State after Prepare is ");
        verifyState(state);

        /****************************Record Image*************************************/
        if (screenShot)
        {
            pRawBuffer.pData = NULL;
            pRawBuffer.size = 0;
        }
        else
        {
            pImageInfo.width = width;
            pImageInfo.height = height;
            pImageInfo.format = ImageFormat_Yuv420; //currently unused in stack
            readFile(inputFileName, &pRawBuffer);
        }
        movieStatus = sri->RecordImage(&pRawBuffer, &pImageInfo);
        if (movieStatus == movie::Status_Success){
            NN_SDK_LOG("*****Record image ImageInfo is height:%d and width:%d*****\n", pImageInfo.height, pImageInfo.width);

            sri->GetState(&state);
            NN_SDK_LOG("State after RecordImage is ");
            verifyState(state);

            /****************************Get Image Size*************************************/
            size_t jpegSize;
            sri->GetImageSize(&jpegSize);
            NN_SDK_LOG("*****The output JPEG image size is :%d*****\n", jpegSize);

            /****************************Get Image*************************************/

            /*pImageBuffer.size = jpegSize;
            pImageBuffer.pData = (uint8_t*)malloc(jpegSize);
            NN_SDK_LOG("calling getImage\n");


            sri->GetImage(&pImageBuffer, &pJpegInfo);
            NN_SDK_LOG("save image on host\n");
            save(outFilePath, &pImageBuffer);*/


        }
        else
            NN_SDK_LOG("*****Record image failed *********\n");

        /***************************Test Reset after ready state *******************/
        sri->Reset();
        NN_SDK_LOG("*****Reset is done*****\n");

        sri->GetState(&state);
        NN_SDK_LOG("State after Reset is ");
        verifyState(state);

        /****************************Prepare**************************************/
        config.returnThumbnail = false;
        movieStatus = sri->Prepare(&config);
        if (movieStatus != movie::Status_Success)
            NN_SDK_LOG(" ******Prepare failed*******\n");
        NN_SDK_LOG("*****Prepare for o/p jpeg is ready*****\n");

        sri->GetState(&state);
        NN_SDK_LOG("State after Prepare is ");
        verifyState(state);

        /****************************Record Image*************************************/
        if (screenShot)
        {
            pRawBuffer.pData = NULL;
            pRawBuffer.size = 0;
        }
        else
        {
            pImageInfo.width = width;
            pImageInfo.height = height;
            pImageInfo.format = ImageFormat_Yuv420; //currently unused in stack
            readFile(inputFileName, &pRawBuffer);
        }
        movieStatus = sri->RecordImage(&pRawBuffer, &pImageInfo);
        if (movieStatus == movie::Status_Success){

            NN_SDK_LOG("*****Record image ImageInfo is height:%d and width:%d*****\n", pImageInfo.height, pImageInfo.width);

            sri->GetState(&state);
            NN_SDK_LOG("State after RecordImage is ");
            verifyState(state);

            /****************************Get Image Size*************************************/
            size_t jpegsize;
            sri->GetImageSize(&jpegsize);
            NN_SDK_LOG("*****The output JPEG image size is :%d\n", jpegsize);

            /****************************Get Image*************************************/

            pImageBuffer.size = jpegsize;
            pImageBuffer.pData = (uint8_t*)malloc(jpegsize);
            NN_SDK_LOG("calling getImage\n");


            sri->GetImage(&pImageBuffer, &pJpegInfo);
            NN_SDK_LOG("*****save image on host*****\n");
            save(outFilePath, &pImageBuffer);
        }
        else
            NN_SDK_LOG("*****Record image failed *********\n");

    }
    else
    {
        NN_SDK_LOG( "\n SriImageSample :: Could not create SRI instance \n" );
    }
    movie::recorder::SRI::Destroy(sri);

    if (sdcardMounted == true)
    {
        nn::fs::Unmount("sdcard");
    }
    else
    {
        nn::fs::UnmountHostRoot();
    }
    MMDestroyAllocator();
    return;


}//NOLINT(impl/function_size)
#endif


