﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/*
 * Copyright (c) 2007 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA Corporation is strictly prohibited.
 */
#pragma once
#ifndef NV_MEDIA_RECORDER_H_

#define NV_MEDIA_RECORDER_H_

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/init.h>


//#define ENABLE_LOG

#ifdef ENABLE_LOG
    #define NN_LOG_V NN_LOG
#else
    #define NN_LOG_V(format, args...) ((void)0)
#endif

#define NN_LOG_E NN_LOG

#include <nn/lmem/lmem_ExpHeap.h>

#include <cstring>
#include <cerrno>
#include <cstdlib>
#include <cstdio>
#include <fcntl.h>

#include <nuplayer/NuPlayerDriver.h>
#include <media/IMediaPlayerClient.h>
#include <media/IMediaPlayerService.h>
#include <media/IMediaHTTPService.h>
#include <utils/Log.h>
#include <ALooper.h>
#include <utils/Vector.h>
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaErrors.h>
#include <media/stagefright/MediaMuxer.h>

#include "MemoryAllocator.h"


const int MAX_COUNT = 22;

using namespace android;

class NvMediaRecorder {
public:
    NvMediaRecorder();

    ~NvMediaRecorder();

    status_t init();
    status_t initVideo();
    status_t initAudio();

    status_t start();
    status_t feedVideoData(sp<ABuffer> abuf, int64_t ts, uint32_t flags);
    status_t feedAudioData(sp<ABuffer> abuf, int64_t ts, uint32_t flags);
    status_t setIFrameInterval(int fps);
    status_t writeData();
    status_t setEncoderFormat(sp<AMessage> msg, bool isAudio, int *trackId);
protected:
    // TO do
private:

    enum {
        MEDIA_CHUNK_INIT,
        MEDIA_CHUNK_PROCESSING,
        MEDIA_CHUNK_COMPLETE,
    };

    enum {
        FRAME_INITIALIZE,
        FRAME_EMPTY,
        FRAME_FILLED,
    };

    sp<MediaMuxer> mMediaMuxer;
    int mIFrameInterval;
    int mStartIndex;
    int mEndIndex;
    int mVideoTrackIdx;
    int mAudioTrackIdx;
    int mFrameIndex;
    bool mFirstFrame;
    int mAudioFrameCount;
    bool mStartIndexInc;

    int64_t mVideotimestamp;
    //int64_t mAudiotimestamp;

    int32_t mCurrentVideoStatus;

    typedef struct _frameData {
        sp<ABuffer> aBuf;
        uint32_t flags;
        int64_t timestamp;
        uint64_t offset;
        int64_t size;
        int32_t state;
    } FrameData;

    typedef struct _videoChunk {
        // 30 frames buffer
        Vector<FrameData *> videoframes;
        int64_t chunkTs;
        int sequence_no;
        int32_t state;
    } videoChunk;

    typedef struct _audioChunk {
        FrameData *audioframes;
        int64_t chunkTs;
        int sequence_no;
        int32_t state;
    } audioChunk;

     Vector<videoChunk *> mVideoChunk;
     Vector<audioChunk *> mAudioChunk;
     FrameData *mConfigData;

     MemoryAllocator *mMemAllocatorAudio;
     MemoryAllocator *mMemAllocatorVideo;
     void *mMemHandleVideo;
     void *mMemHandleAudio;

     android::Mutex mLock;
};
#endif //NV_MEDIA_RECORDER_H_
