﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
 /*
 * Copyright 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#ifndef NV_AUDIO_ENCODER_H_

#define NV_AUDIO_ENCODER_H_

#include <utils/Log.h>
#include <utils/Errors.h>
#include <utils/Timers.h>
#include <utils/Trace.h>
#include <gui/surface.h>
#include <gui/SurfaceComposerClient.h>
#include <gui/ISurfaceComposer.h>
#include <ui/DisplayInfo.h>
#include <media/openmax/OMX_IVCommon.h>
#include <media/stagefright/foundation/ABuffer.h>
#include <media/stagefright/foundation/AMessage.h>
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaSource.h>
#include <media/stagefright/MediaErrors.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/ICrypto.h>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>

#include "fAudioSource.h"
#include "NvMediaRecorder.h"

//#define ENABLE_LOG

#ifdef ENABLE_LOG
    #define NN_LOG_V NN_LOG
#else
    #define NN_LOG_V(format, args...) ((void)0)
#endif

#define NN_LOG_E NN_LOG

typedef void (*fnEvent) (uint32_t event);

using namespace android;

class NvAudioEncoder {
public:
    NvAudioEncoder();

    ~NvAudioEncoder();

    class AudioRecordThread : public android::Thread
    {
    public:
        NvAudioEncoder *mEncoder;
        virtual bool threadLoop();
        virtual void requestExit();
    };

    // Command-line parameters.
    enum {
           FORMAT_MP4,
           FORMAT_H264,
           FORMAT_FRAMES,
           FORMAT_RAW_FRAMES
    };

    const char* kMimeTypeAac;
    const char* kBitRateMode;       // CBR/CQ
    uint32_t kBitRate;
    uint32_t kSampleRate;
    uint32_t kChannelCount;
    uint32_t kAacProfile;         // ProfileLevel: ObjectLC = 2, ObjectHE = 5, ObjectELD = 39;
    uint32_t kMaxTimeLimitSec;  // 3 minutes
    uint32_t gOutputFormat;

    bool aEncoder;
    bool pcmSrc;
    bool fakeAudioSrc;

    uint32_t gTimeLimitSec;;
    uint32_t gFrameBufSize;
    uint8_t  gWavHeaderSize;
    void* wavData;
    std::size_t dataSize;
    std::size_t gDataOffset;

    bool gAudioDone;
    bool mStopCalled;

    fnEvent mEventCallback;

    NvMediaRecorder *mMediaRecorder;

    sp<MediaSource> audioSource;
    sp<MediaCodec> mAudioEncoder;
    android::sp<AudioRecordThread> mAudioThread;

    volatile bool gStopRequested;

    status_t start(NvMediaRecorder *aRecorder, fnEvent evenClk);
    status_t stop();
    void createAudioSource();
    void destroyAudioSource();

    void generateAudioFrame(int frameIndex, uint8_t* frameData);

    void addADTSHeader(char* buf, int packetLen);
    std::size_t aacReadWavFile(void** data, const char* filename);

    status_t runAudioEncoder(const sp<MediaCodec>& encoder,
                                    const sp<MediaMuxer>& muxer) ;
    sp<MediaCodec> prepareAudioEncoder();
};

#endif //NV_AUDIO_ENCODER_H_
