﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/*
 * Copyright (c) 2007 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA Corporation is strictly prohibited.
 */
#pragma once
#ifndef MEMORY_ALLOCATOR_H_

#define MEMORY_ALLOCATOR_H_

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/init.h>

#include <nn/lmem/lmem_ExpHeap.h>

#include <cstring>
#include <cerrno>
#include <cstdlib>
#include <cstdio>
#include <fcntl.h>

#include <utils/Log.h>
#include <utils/Vector.h>

using namespace android;

class MemoryAllocator {
public:
    MemoryAllocator();

    ~MemoryAllocator();

    // will return offset of the memory
    uint8_t *init(uint32_t allocSize);
    uint8_t *getMemory(uint32_t size, uint64_t *offset, int32_t *status);
    status_t freeMemory(int32_t size);

    enum {
        MEMORY_AVAILABLE,
        MEMORY_FULL,
    };

protected:
    // TO do
private:

    typedef struct block {
        uint32_t startOffset;
        uint32_t endOffset;
        uint32_t size;
    } mem_block;

    Vector<mem_block *> mMemBlock;

    int64_t mTotalSize;
    int64_t mFilledSize;
    int64_t mFreeSize;
    int32_t mAllocIndex;
    int32_t mFreeIndex;
    uint64_t mCurrentOffset;
    uint8_t *mMemHandle;

};
#endif //MEMORY_ALLOCATOR_H_
