﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/



#define DECODER_DUMP
#include <cstdlib>

#include <mm_MemoryManagement.h>
#include <nnt/nntest.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/fs.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/init.h>
#include <cstdio>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <nv/nv_MemoryManagement.h>
#include <nv/nv_ServiceName.h>
#include <cerrno>
#include "MjpegDec.h"
#if 1

namespace{

    const int FsHeapSize = 512 * 1024;

    uint8_t              g_FsHeapBuffer[FsHeapSize];
    nn::lmem::HeapHandle g_FsHeap;

    void FsInitHeap()
    {
        g_FsHeap = nn::lmem::CreateExpHeap(g_FsHeapBuffer, FsHeapSize, nn::lmem::CreationOption_DebugFill);
    }

    void* FsAllocate(size_t size)
    {
        return nn::lmem::AllocateFromExpHeap(g_FsHeap, size);
    }

    void FsDeallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
            return nn::lmem::FreeToExpHeap(g_FsHeap, p);
    }

}

namespace // 'unnamed'
{
nn::mem::StandardAllocator g_MultimediaAllocator;
}

void MMCreateAllocator()
{
    const int allocatorSize = 512 << 20;
    static char s_MMAllocatorBuffer[allocatorSize];
    g_MultimediaAllocator.Initialize(s_MMAllocatorBuffer, sizeof(s_MMAllocatorBuffer));
}

void MMDestroyAllocator()
{
    g_MultimediaAllocator.Finalize();
}

void *MMAlloc(size_t size, size_t alignment, void*)
{
    return g_MultimediaAllocator.Allocate(size, alignment);
}

void MMFree(void *p, void*)
{
    g_MultimediaAllocator.Free(p);
}

void *MMRealloc(void *p, size_t newSize, void*)
{
    return g_MultimediaAllocator.Reallocate(p, newSize);
}

//----------------------------------------------------------
// nninitStartup() is invoked before calling nnMain().
//----------------------------------------------------------

extern "C" void nninitStartup()
{
    #if 1
    const size_t heapSize = 128 << 20;
    const size_t mallocSize = 32 << 20;
    uintptr_t address;
    nn::Result result;

    result = nn::os::SetMemoryHeapSize(heapSize);
    //ASSERT(result.IsSuccess());

    result = nn::os::AllocateMemoryBlock(&address, mallocSize);
    //ASSERT(result.IsSuccess());

    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), mallocSize);
    FsInitHeap();
    nn::fs::SetAllocator(FsAllocate, FsDeallocate);
    //NN_SDK_LOG("\ninit done: \n");
    #endif
}

const unsigned long int CRC32_POLYNOMIAL = 0xEDB88320L;

static uint32_t CRCTable[256];
static void BuildCRCTable()
{
    uint16_t i;
    uint16_t j;
    uint32_t crc;
    for (i = 0; i <= 255; i++)
    {
       crc = i;
        for (j = 8; j > 0; j--)
        {
            if (crc & 1)
            {
                crc = (crc >> 1) ^ CRC32_POLYNOMIAL;
            }
            else
            {
                crc >>= 1;
            }
        }
        CRCTable[i] = crc;
    }
}
static int32_t CalculateBufferCRC(uint32_t count, uint32_t crc, uint8_t *buffer)
{
    uint8_t *p;
    uint32_t temp1;
    uint32_t temp2;
    p = (uint8_t*)buffer;

    while (count-- != 0)
    {
        temp1 = (crc >> 8) & 0x00FFFFFFL;
        temp2 = CRCTable[((uint32_t)crc ^ *p++) & 0xFF];
        crc = temp1 ^ temp2;
    }

    return crc;
}

static void displayUsage()
{
    NN_SDK_LOG("usage: %s --in <file> --out <Output file Path> [--no-output-files]\n", nn::os::GetHostArgv()[0]);
}

int save(char* path, Buffer* pixBuf, aviStreamInfo streamInfo)
{
    int dataSize;
    nn::Result result;
    nn::fs::FileHandle fileHandle;

    dataSize = ((streamInfo.width + 15) & ~15) * streamInfo.height * 1.5;
    nn::fs::CreateFile(path, dataSize).IsSuccess();

    result = nn::fs::OpenFile(&fileHandle, path, nn::fs::OpenMode_Write);
    NN_ASSERT(result.IsSuccess());
    result = nn::fs::WriteFile(fileHandle, 0, pixBuf->GetDataPtr(), dataSize, nn::fs::WriteOption::MakeValue(nn::fs::WriteOptionFlag_Flush));
    NN_SDK_LOG("%s:%d result = 0x%x, size = %d \n", __func__, __LINE__, result, dataSize);
    nn::fs::CloseFile(fileHandle);
    return 0;
}

int fileName(char* outFilePath, char* buf)
{
    char buf1[15];
    static int fn = 0;
    const char* token = "sdcard";
    strcpy(buf, outFilePath);
    int compare = strncmp(outFilePath, token, strlen(token));
    if (compare == 0)
        sprintf(buf1,"avi.%04d.yuv",fn);
    else
        sprintf(buf1,"/avi.%04d.yuv",fn);

    strcat(buf, buf1);
    NN_SDK_LOG("Path is :%s\n",buf);
    fn++;
    return 0;

}

/* Process main entry */
TEST(MjpegPlaybackTest, Video)
{
    MMCreateAllocator();
    NN_SDK_LOG("Calling nv::mm::SetAllocator\n");
    nv::mm::SetAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    NN_SDK_LOG("Calling nv::SetGraphicsAllocator\n");
    nv::SetGraphicsAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    nv::SetGraphicsServiceName("nvdrv:t");
    NN_SDK_LOG("Calling nv::SetGraphicsDevtoolsAllocator\n");
    nv::SetGraphicsDevtoolsAllocator(MMAlloc, MMFree, MMRealloc, nullptr);
    const int mmFirmwareMemorySize = 8 << 20;
    NN_ALIGNAS(4096) static char s_mmFirmwareMemory[mmFirmwareMemorySize];
    NN_SDK_LOG("Calling nv::InitializeGraphics\n");
    nv::InitializeGraphics(s_mmFirmwareMemory, sizeof(s_mmFirmwareMemory));
    int argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();
    const char* inputFileName = 0;
    char* outFilePath = 0;
    bool noOutputFiles = false;
    const char *crcFileName = NULL;
    aviStreamInfo streamInfo;
    //uint16_t Width = 1536, Height = 2048;
    //Buffer pixBuf(Width * Height * 4);
    int i;
    char* actualPath;
    HANDLE handle;

    for (int i = 1; i < argc; i++)
    {
        if(!strcmp(argv[i], "--no-output-files")){
            noOutputFiles = true;
            continue;
            }
        if(argc - i < 2)
            break;
        if(!strcmp(argv[i], "--in"))
            inputFileName = argv[++i];
        else if(!strcmp(argv[i], "--out")){
            outFilePath = (char*)malloc(strlen(argv[++i]) + 1);
            strcpy(outFilePath, argv[i]);
            }
        else if(!strcmp(argv[i], "--crc"))
            crcFileName = argv[++i];
        else
        {
            displayUsage();
            return;
        }
    }
    if(!inputFileName || !(outFilePath || noOutputFiles))
    {
        displayUsage();
        return;
    }

    if (crcFileName != NULL)
        BuildCRCTable();

    bool sdcardMounted = false;
    const char* token = "sdcard";
    int compare = strncmp(inputFileName, token, strlen(token));
    if (compare == 0)
    {
        nn::Result resultSdcardMount = nn::fs::MountSdCardForDebug("sdcard");
        if (resultSdcardMount.IsFailure())
        {
            NN_SDK_LOG("nn::fs::SD card Mount failure. Module:%d, Description:%d\n",
                    resultSdcardMount.GetModule(),
                    resultSdcardMount.GetDescription());
            return;
        }
        sdcardMounted = true;
    }
    else
    {
        nn::Result resultHostMount = nn::fs::MountHostRoot();
        if (resultHostMount.IsFailure())
        {
            NN_SDK_LOG("nn::fs::Host root mount failure.\n",
                    resultHostMount.GetModule(),
                    resultHostMount.GetDescription());
            return;
        }

    }
    if(nn::movie::mjpeg::initialize(&handle))
    {
        nn::fs::FileHandle CrcHandle;

        if (crcFileName != NULL)
        {
            nn::Result result = nn::fs::OpenFile(&CrcHandle, crcFileName, nn::fs::OpenMode_Read);
            ASSERT_TRUE(result.IsSuccess());
        }

        if(nn::movie::mjpeg::setDataSource(handle, inputFileName))
        {
            uint32_t Crc = 0, Offset = 0;
            nn::movie::mjpeg::prepare(handle);
            nn::movie::mjpeg::getStreamInfo(handle, &streamInfo);
            NN_LOG("Total frame count is:%d\n",streamInfo.totalNumberOfFrames);
            Buffer pixBuf(streamInfo.width * streamInfo.height * 4);
            for(i=0; i< streamInfo.totalNumberOfFrames; i++){
                NN_LOG("***frame count :%d***\n",i);
                nn::movie::mjpeg::getFrame(handle, &pixBuf);
#ifdef DECODER_DUMP
                if(!noOutputFiles){
                    actualPath = (char*)malloc(strlen(outFilePath) + 16);
                    fileName(outFilePath, actualPath);
                    save(actualPath, &pixBuf, streamInfo);
                }
#endif
                if (crcFileName != NULL)
                {
                    uint32_t RefCrc;
                    char *pData, Data[16];

                    pData = Data;
                    do {
                        nn::Result result = nn::fs::ReadFile(CrcHandle, Offset, pData, 1);
                        ASSERT_TRUE(result.IsSuccess());
                        Offset++;

                        if (*pData++ == 0x0D)   // Newline
                        {
                            nn::Result result = nn::fs::ReadFile(CrcHandle, Offset, pData, 1);
                            ASSERT_TRUE(result.IsSuccess());
                            RefCrc = strtoul(Data, NULL, 16);
                            break;
                        }
                    } while(1);

                    Crc = CalculateBufferCRC(streamInfo.width * streamInfo.height * 1.5, 0, (uint8_t *)(pixBuf.GetDataPtr()));

                    if (RefCrc != Crc)
                    {
                        NN_SDK_LOG("FAIL Crc = %x, RefCrc = %x\n", Crc, RefCrc);
                        FAIL();
                    }
                }
            }
        }

        if (crcFileName != NULL)
            nn::fs::CloseFile(CrcHandle);

        nn::movie::mjpeg::finalize(handle);

    }
    else
        NN_LOG("Failed to initialize mjpeg decoder\n");

    if (sdcardMounted == true)
    {
        nn::fs::Unmount("sdcard");
    }
    else
    {
        nn::fs::UnmountHostRoot();
    }
    MMDestroyAllocator();
    return;


}//NOLINT(impl/function_size)
#endif

