﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/audio.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

#include <movie/Utils.h>
#include <movie/Decoder.h>
#include <movie/Extractor.h>
#include <vector>

void AudioOutRendererThreadFunction(void *arg);
class AudioOutRenderer
{
public:
    AudioOutRenderer();

    ~AudioOutRenderer();

    movie::Status Initialize();

    movie::Status Finalize();

    movie::Status Open(movie::Decoder* audioDecoder, uint32_t sampleRate, int channelCount);

    movie::Status Start();

    movie::Status Render();

    void Stop();

    void Close();

    friend void AudioOutRendererThreadFunction(void *arg);

    void OnOutputAvailable(int index, int64_t presentationTimeUs, uint32_t flags);

    bool DoneProcessing();

    bool IsAudioOutStarted();

    int32_t GetRenderInterval();

    bool m_Started;

protected:
    movie::Decoder* m_AudioDecoder;
    bool m_ThreadDone;
    bool m_RenderThreadCreated;
    bool m_AudioOutStarted;
    bool m_AudioOutOpened;
    int m_SampleRate;
    int m_Channels;
    int m_InputSampleRate;
    int m_InputChannels;
    int m_FrameSize;
    int64_t m_PresentationTimeUs;

    size_t m_AudioRendererThreadstacksize;
    char* m_AudioRendererThreadstack;

    nn::os::ThreadType  m_AudioRendererThreadType;
    nn::audio::AudioOut m_AudioOut;
    nn::audio::SampleFormat m_SampleFormat;
    size_t m_SampleSize;
    static const int numBuffers = 3;
    void *m_OutBuffers[numBuffers];
    char* inAudioBuffer;
    int32_t inAudioBufferSize;
    nn::audio::AudioOutBuffer audioOutBuffer[numBuffers];

    struct audioData
    {
        int index;
        int64_t presentationTimeUs;
        uint32_t flags;
    };
    std::vector<audioData> m_AudioCodecBuffers;
    int32_t m_RenderIntervalMs;
    size_t m_BufferSize;
    nn::os::MutexType m_AudioBufferVectorMutex;
};

