﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
 /*
 * Copyright 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <cassert>
#include <cctype>
#include <fcntl.h>
//#include <cinttypes>
#include <getopt.h>
#include <csignal>
//#include <stdio.h>
//#include <stdlib.h>
#include <cstring>
#include <sys/wait.h>
#include <termios.h>
//#include <unistd.h>
#define LOG_TAG "ScreenRecord"
#define ATRACE_TAG ATRACE_TAG_GRAPHICS
//#define LOG_NDEBUG 0
#include <utils/Log.h>
#include <binder/IPCThreadState.h>
#include <utils/Errors.h>
#include <utils/Timers.h>
#include <utils/Trace.h>
#include <gui/Surface.h>
#include <gui/SurfaceComposerClient.h>
#include <gui/ISurfaceComposer.h>
#include <ui/DisplayInfo.h>
#include <media/openmax/OMX_IVCommon.h>
#include <media/stagefright/foundation/ABuffer.h>
#include <media/stagefright/foundation/AMessage.h>
#include <media/stagefright/MediaCodec.h>
#include <media/stagefright/MediaErrors.h>
#include <media/stagefright/MediaMuxer.h>
#include <media/ICrypto.h>
#include "screenrecord.h"

#ifdef RAPTOR_ENHANCEMENT
long double strtold (const char *__restrict, char **__restrict);
_Noreturn void _Exit (int);
#include <nn/fs.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <ALooper.h>
#else
#include "HorizonDisplay.h"
#include "HorizonPlayer.h"
#include "HorizonAlloc.h"
#include "HorizonBase\HorizonStorage.h"
#include "HorizonBase\HorizonFile.h"

#include "HorizonStorage.h"
#define FILE_DUMP

#endif

#include <nn/init.h>
#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nnt/nntest.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nv/nv_MemoryManagement.h>
#include <nv/nv_ServiceName.h>
#include <mm_MemoryManagement.h>
#include <mm_Threads.h>

#include "WebmFrame.h"

#ifdef RAPTOR_ENHANCEMENT
extern void initializeLooperRoster();
extern void initializeAtomizer();
extern void initializeDataSource();
#endif
//extern void InitializeWebFrame();
extern void initializeWebFrame();
extern void shutdownWebFrame();

using namespace android;
static const uint32_t kMinBitRate = 100000;         // 0.1Mbps
static const uint32_t kMaxBitRate = 200 * 1000000;  // 200Mbps
static const uint32_t kMaxTimeLimitSec = 180;       // 3 minutes
static const uint32_t kFallbackWidth = 1280;        // 720p
static const uint32_t kFallbackHeight = 720;
static const char* kMimeTypeAvc = "video/avc";
// Command-line parameters.
static bool gVerbose = false;           // chatty on stdout
static bool gRotate = false;            // rotate 90 degrees
static enum {
    FORMAT_MP4, FORMAT_H264, FORMAT_FRAMES, FORMAT_RAW_FRAMES
} gOutputFormat = FORMAT_MP4;           // data format for output
static bool gSizeSpecified = false;     // was size explicitly requested?
static bool gWantInfoScreen = false;    // do we want initial info screen?
static bool gWantFrameTime = false;     // do we want times on each frame?
static uint32_t gVideoWidth = 320;        // default width+height
static uint32_t gVideoHeight = 240;
static uint32_t gBitRate = 2000000;     // 2Mbps
static uint32_t gFrameRate = 15;
static uint32_t gTimeLimitSec = kMaxTimeLimitSec;
static volatile bool gStopRequested;
//Previous signal handler state, restored after first hit.
static struct sigaction gOrigSigactionINT;
static struct sigaction gOrigSigactionHUP;



static int TEST_Y = 120;                  // YUV values for colored rect
static int TEST_U = 160;
static int TEST_V = 200;
static int NUM_FRAMES = 30;
#ifdef RAPTOR_ENHANCEMENT
namespace{

    const int FsHeapSize = 512 * 1024;
    const int mmHeapSize = 512 << 20;
    const int mmFirmwareMemorySize = 8 << 20;

    uint8_t              g_FsHeapBuffer[FsHeapSize];
    nn::lmem::HeapHandle g_FsHeap;
    char                        g_mmHeapBuffer[mmHeapSize];
    nn::mem::StandardAllocator  g_MultimediaAllocator(g_mmHeapBuffer, sizeof(g_mmHeapBuffer));

    char                        g_mmFirmwareMemory[mmFirmwareMemorySize] __attribute__((aligned(4096)));

    void FsInitHeap()
    {
        g_FsHeap = nn::lmem::CreateExpHeap(g_FsHeapBuffer, FsHeapSize, nn::lmem::CreationOption_DebugFill);
    }

    void* FsAllocate(size_t size)
    {
        return nn::lmem::AllocateFromExpHeap(g_FsHeap, size);
    }

    void FsDeallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
            return nn::lmem::FreeToExpHeap(g_FsHeap, p);
    }
    void* MultimediaAllocate(size_t size, size_t alignment, void *userPtr)
    {
        return g_MultimediaAllocator.Allocate(size, alignment);
    }

    void MultimediaFree(void *addr, void *userPtr)
    {
        g_MultimediaAllocator.Free(addr);
    }

    void *MultimediaReallocate(void* addr, size_t newSize, void *userPtr)
    {
        return g_MultimediaAllocator.Reallocate(addr, newSize);
    }

}
extern "C" void nninitStartup()
{
    const size_t heapSize = 128 << 20;
    const size_t mallocSize = 32 << 20;
    uintptr_t address;
    nn::Result result;

    result = nn::os::SetMemoryHeapSize(heapSize);
    //ASSERT(result.IsSuccess());

    result = nn::os::AllocateMemoryBlock(&address, mallocSize);
    //ASSERT(result.IsSuccess());

    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), mallocSize);
    FsInitHeap();
    nn::fs::SetAllocator(FsAllocate, FsDeallocate);
    NN_SDK_LOG("\ninit done: \n");
}

#else
extern "C" void nninitStartup()
{
}
#endif

static status_t releaseEncoder() {
    status_t err;

    err = NO_ERROR;

    return err;
    // Release decoder and cleanup

}
/*
 * Configures and starts the MediaCodec encoder.  //Obtains an input surface
 * from the codec.
 */

static status_t prepareEncoder(sp<MediaCodec>* pCodec){

    status_t err;
    sp<AMessage> format = new AMessage;
    format->setInt32("width", gVideoWidth);
    format->setInt32("height", gVideoHeight);
    format->setString("mime", kMimeTypeAvc);
    format->setInt32("encoder", true);
    //format->setInt32("color-format", OMX_COLOR_FormatAndroidOpaque);
    format->setInt32("color-format", OMX_COLOR_FormatYUV420Planar);
    format->setInt32("bitrate", gBitRate);
    format->setFloat("frame-rate", gFrameRate);
    format->setInt32("i-frame-interval", 10);
    //format->setInt32("prepend-sps-pps-to-idr-frames", 0);
    NN_LOG("New Looper\n");
    sp<ALooper> looper = new ALooper;
    looper->setName("screenrecord_looper");
    looper->start();
    NN_LOG("Creating codec\n");
    sp<MediaCodec> codec = MediaCodec::CreateByType(looper, kMimeTypeAvc, true);
    if (codec == NULL) {
        NN_LOG( "ERROR: unable to create %s codec instance\n",
                kMimeTypeAvc);
        return UNKNOWN_ERROR;
    }
    err = codec->configure(format, NULL, NULL,
            MediaCodec::CONFIGURE_FLAG_ENCODE);
    if (err != NO_ERROR) {
        NN_LOG( "ERROR: unable to configure %s codec at %dx%d (err=%d)\n",
                kMimeTypeAvc, gVideoWidth, gVideoHeight, err);
        codec->release();
        return err;
    }
    NN_LOG("Starting codec");
    err = codec->start();
    if (err != NO_ERROR) {
        NN_LOG( "ERROR: unable to start codec (err=%d)\n", err);
        codec->release();
        return err;
    }
    NN_LOG("Codec prepared\n");
    *pCodec = codec;
    return err;

}

/**
 * Generates data for frame N into the supplied buffer.  We have an 8-frame animation
 * sequence that wraps around.  It looks like this:
 * <pre>
 *   0 1 2 3
 *   7 6 5 4
 * </pre>
 * We draw one of the eight rectangles and leave the rest set to the zero-fill color.
 */
void generateFrame(int frameIndex, int colorFormat, uint8_t* frameData) {
    int HALF_WIDTH = gVideoWidth / 2;
    //boolean semiPlanar = isSemiPlanarYUV(colorFormat);
    bool semiPlanar = false;
    // Set to zero.  In YUV this is a dull green.
    // Arrays.fill(frameData, (byte) 0);
    int startX, startY, countX, countY;
    frameIndex %= 8;
    //frameIndex = (frameIndex / 8) % 8;    // use this instead for debug -- easier to see
    if (frameIndex < 4) {
        startX = frameIndex * (gVideoWidth / 4);
        startY = 0;
    } else {
        startX = (7 - frameIndex) * (gVideoWidth / 4);
        startY = gVideoHeight / 2;
    }
    for (int y = startY + (gVideoHeight / 2) - 1; y >= startY; --y) {
        for (int x = startX + (gVideoWidth / 4) - 1; x >= startX; --x) {
            if (semiPlanar) {
                frameData[y * gVideoWidth + x] = (char) TEST_Y;
                if ((x & 0x01) == 0 && (y & 0x01) == 0) {
                    frameData[gVideoWidth*gVideoHeight + y * HALF_WIDTH + x] = (char) TEST_U;
                    frameData[gVideoWidth*gVideoHeight + y * HALF_WIDTH + x + 1] = (char) TEST_V;
                }
            } else {
                // full-size Y, followed by quarter-size U and quarter-size V (COLOR_FormatYUV420Planar)
                frameData[y * gVideoWidth + x] = (char) TEST_Y;
                if ((x & 0x01) == 0 && (y & 0x01) == 0) {
                    frameData[gVideoWidth*gVideoHeight + (y / 2) * HALF_WIDTH + (x / 2)] = (char) TEST_U;
                    frameData[gVideoWidth*gVideoHeight + HALF_WIDTH * (gVideoHeight / 2) +
                              (y / 2) * HALF_WIDTH + (x / 2)] = (char) TEST_V;
                }
            }
        }
    }
}

/**
 * Generates the presentation time for frame N, in microseconds.
 */
static long computePresentationTime(int frameIndex) {
    return 132 + frameIndex * 1000000 / gFrameRate;
}
/*
 * Runs the MediaCodec encoder, sending the output to the MediaMuxer.
 *
 * Exactly one of muxer
 *
 * The muxer must *not* have been started before calling.
 */
static status_t runEncoder(const sp<MediaCodec>& encoder,const sp<MediaMuxer>& muxer){
    static int kTimeout = 250000;
    Vector<sp<ABuffer> > mInBuffers;
    Vector<sp<ABuffer> > mOutBuffers;
    ssize_t trackIdx = -1;

#ifdef ENABLE_METADATA_WRITER
    ssize_t metadataTrackIdx = -1;
    uint64_t nSampleCount = 0;
#endif

    uint32_t debugNumFrames = 0;
    status_t err;
    size_t index;

    bool inputDone = true;
    bool outputDone = false;
    int generateIndex = 0;
    uint8_t *frameData = new uint8_t[gVideoWidth * gVideoHeight * 3 / 2];

    #ifdef FILE_DUMP
    HorizonStorage gStorage;
    gStorage.Initialize("c:/");
    MoFile *File;
    MoFile *File1;
    File = gStorage.OpenFile("Temp/MediaCodec_out.h264", 'c');
    if (File == NULL) {
        NN_ASSERT(false && "Error file open failed.\n");
    } else {
        NN_LOG("FILE open success");
    }

    File1 = gStorage.OpenFile("Temp/MediaCodec_gen.yuv", 'c');
    if (File1 == NULL) {
        NN_ASSERT(false && "Error file open failed.\n");
    } else {
        NN_LOG("FILE1 open success");
    }
    #endif

    err = encoder->getInputBuffers(&mInBuffers);
    if (err != NO_ERROR) {
        NN_LOG("Unable to get output buffers (err=%d)\n", err);
        return err;
    }
    err = encoder->getOutputBuffers(&mOutBuffers);
    if (err != NO_ERROR) {
        NN_LOG("Unable to get output buffers (err=%d)\n", err);
        return err;
    }
    NN_LOG("got %d input and %d output buffers",mInBuffers.size(), mOutBuffers.size());
    while (!outputDone) {
        if(!inputDone) {
            err = encoder->dequeueInputBuffer(&index,kTimeout);
            if (err == OK) {
                long ptsUsec = computePresentationTime(generateIndex);
                if (generateIndex == NUM_FRAMES) {
                    // Send an empty frame with the end-of-stream flag set.  If we set EOS
                    // on a frame with data, that frame data will be ignored, and the
                    // output will be short one frame.
                    err = encoder->queueInputBuffer(
                                index,
                                0 /* offset */,
                                0 /* size */,
                                ptsUsec,
                                MediaCodec::BUFFER_FLAG_EOS);
                    inputDone = true;
                }
                else{
                    NN_LOG("filling input buffer %d\n", index);
                    generateFrame(generateIndex, OMX_COLOR_FormatYUV420Planar, frameData);
                    const sp<ABuffer> &buffer = mInBuffers.itemAt(index);
                    if(buffer->capacity() < gVideoWidth * gVideoHeight * 3 / 2){
                        NN_ASSERT(false &&"Buffer capacity is less than required\n");
                    }
                    // write in buffer frameData
                    memset(buffer->data(), 0, gVideoWidth * gVideoHeight * 3 / 2);
                    memcpy((uint8_t *)buffer->data(),frameData, gVideoWidth * gVideoHeight * 3 / 2);
                    #ifdef FILE_DUMP
                    File1->Write(buffer->data(),buffer->size());
                    #endif
                    uint32_t bufferFlags = 0;
                    err = encoder->queueInputBuffer(
                            index,
                            0 /* offset */,
                            buffer->size(),
                            ptsUsec,
                            bufferFlags);
                }
                generateIndex++;
            } else {
                 NN_LOG("**filling input buffer error %d\n**", index);
            }
        }
        gStopRequested = false;
        if(!gStopRequested) {
            size_t bufIndex, offset, size;
            int64_t ptsUsec;
            uint32_t flags;
            NN_LOG("Calling dequeueOutputBuffer");
            err = encoder->dequeueOutputBuffer(&bufIndex, &offset, &size, &ptsUsec,
                    &flags, kTimeout);
            NN_LOG("dequeueOutputBuffer returned %d", err);
            inputDone = false;
            switch (err) {

            case NO_ERROR:
                NN_LOG("write sampl eGot codec config buffer (%zu bytes)", size);
                #ifdef FILE_DUMP
                if(bufIndex >= 0 && size != 0){
                    ABuffer *aBuffer;
                    aBuffer = mOutBuffers[bufIndex].get();
                    //aBuffer->setRange(offset,size);
                    uint8_t* buf = aBuffer->data();
                    File->Write(buf,size);

                }
                #endif
                NN_LOG("Got codec config buffer (%zu bytes)", size);
                if ((flags & MediaCodec::BUFFER_FLAG_CODECCONFIG) != 0) {
                    NN_LOG("BUFFER_FLAG_CODECCONFIG (%zu bytes)", size);

                    if (muxer != NULL) {
                        // ignore this -- we passed the CSD into MediaMuxer when
                        // we got the format change notification
                        size = 0;
                    }
                }
                if (size != 0) {
                    if(trackIdx == -1){
                        NN_ASSERT(false && "******TrackIdx != -1 error\n");
                    }
                    NN_LOG("\nSet System time :%d\n",ptsUsec);
                    if (muxer != NULL) {
                        err = muxer->writeSampleData(mOutBuffers[bufIndex], trackIdx,
                                                ptsUsec, flags);
                    }
                    if (err != NO_ERROR) {
                        NN_LOG("Failed writing data to muxer (err=%d)\n", err);
                        return err;
                    }

#ifdef ENABLE_METADATA_WRITER
                    // Write metadata
                    sp<ABuffer> metadataWriteBuffer = new ABuffer(sizeof(uint64_t));
                    *(metadataWriteBuffer->data()) = nSampleCount;
                    nSampleCount++;

                    err = muxer->writeSampleData(metadataWriteBuffer, metadataTrackIdx,
                        ptsUsec, android::MediaCodec::BUFFER_FLAG_SYNCFRAME);

                    if (err != NO_ERROR) {
                        NN_LOG("\nFailed writing data to muxer (err=%d)\n", err);
                        return err;
                    }
#endif
                }
                err = encoder->releaseOutputBuffer(bufIndex);
                if (err != NO_ERROR) {
                    NN_LOG("Unable to release output buffer (err=%d)\n",err);
                    return err;
                }
                if ((flags & MediaCodec::BUFFER_FLAG_EOS) != 0) {
                    // Not expecting EOS from SurfaceFlinger.  Go with it.
                    NN_LOG("Received end-of-stream");
                    gStopRequested = true;
                    outputDone = true;
                }
                break;
            case -EAGAIN:                       // INFO_TRY_AGAIN_LATER
                NN_LOG("Got -EAGAIN, looping ..Try again later");//*
                break;
            case INFO_FORMAT_CHANGED:           // INFO_OUTPUT_FORMAT_CHANGED//*
                {
                    // Format includes CSD, which we must provide to muxer.
                    NN_LOG("Encoder format changed");
                    sp<AMessage> newFormat;
                    encoder->getOutputFormat(&newFormat);
                    if (muxer != NULL) {
                        trackIdx = muxer->addTrack(newFormat);
#ifdef ENABLE_METADATA_WRITER
                        sp<AMessage> metadataFormat = new AMessage();
                        metadataFormat->setString("mime", "application/sampleCount");
                        metadataTrackIdx = muxer->addTrack(metadataFormat);
                        NN_LOG("Starting muxer with trackIdx : %d metadataTrackIdx: %d\n", trackIdx, metadataTrackIdx);
#else
                        NN_LOG("Starting muxer with trackIdx : %d\n",trackIdx );
#endif
                        err = muxer->start();
                        if (err != NO_ERROR) {
                            NN_LOG("Unable to start muxer (err=%d)\n", err);
                            return err;
                        }
                    }
                    else
                    {
                        ++trackIdx;
                    }
                }
                break;
            case INFO_OUTPUT_BUFFERS_CHANGED:   // INFO_OUTPUT_BUFFERS_CHANGED //*
                // Not expected for an encoder; handle it anyway.
                NN_LOG("Encoder buffers changed");
                err = encoder->getOutputBuffers(&mOutBuffers);
                if (err != NO_ERROR) {
                    NN_LOG("Unable to get new output buffers (err=%d)\n", err);
                    return err;
                }
                break;
            case INVALID_OPERATION:
                NN_LOG("dequeueOutputBuffer returned INVALID_OPERATION");
                return err;
            default:
                NN_LOG("Got weird result %d from dequeueOutputBuffer\n", err);
                return err;
            }
        }
    }
    NN_LOG("Encoder stopping (req=%d)", gStopRequested);
    return NO_ERROR;


}//NOLINT(impl/function_size)

/*
 * Parses args and kicks things off.
 */
TEST(MediaCodecEncoderTest, Encoder)
{
    const int kExtraHeapMemMB = 64;
    status_t err;
    sp<MediaCodec> encoder;
    /* Set allocator callback functions */
    nv::mm::SetAllocator(MultimediaAllocate, MultimediaFree, MultimediaReallocate, NULL);
    nv::mm::SetThreadStackAllocator(MultimediaAllocate, MultimediaFree, NULL);
    nv::SetGraphicsAllocator(MultimediaAllocate, MultimediaFree, MultimediaReallocate, NULL);
    nv::SetGraphicsServiceName("nvdrv:t");
    nv::SetGraphicsDevtoolsAllocator(MultimediaAllocate, MultimediaFree, MultimediaReallocate, NULL);
    nv::InitializeGraphics(g_mmFirmwareMemory, sizeof(g_mmFirmwareMemory));
#ifndef RAPTOR_ENHANCEMENT
    MV_OSMemoryHeapResize(kExtraHeapMemMB);             // allocate an extra kExtraHeapMemMB MB to use.
    MV_HeapCreate(eMVHeapNN, kExtraHeapMemMB);          // pull (N) MB from the OS memory Heap, and use it for our NN heap
    MV_UseHeap(eMVHeapNN);
    HorizonStorage gStorage;
    gStorage.Initialize("c:/");
    //MV_setTrace(eMVTraceNone,0);                        // eMVTraceNone: don't trace alloc's or free's
    //MV_check("MediaCodec Encoder API MEMORY PROFILE BEFORE Global()", 3,0,-1);
    SfGlobal::Global();
    //MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER Global()", 3,0,-1);
    //initializeWebFrame();
#else
    initializeLooperRoster();
    initializeAtomizer();
    initializeDataSource();
#endif
    NN_LOG("Inside Main, Calling PrepareEncoder\n");
    err = prepareEncoder( &encoder);
    //MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER prepareEncoder()", 3,0,-1);

    NN_LOG("Preprare encoder is ready\n");
    if (err != NO_ERROR){
        encoder->release();
        FAIL();
    }
    sp<MediaMuxer> muxer = NULL;
    const int argc = nn::os::GetHostArgc();
    const char * const * const argv = nn::os::GetHostArgv();
    bool noOutputFiles = (argc > 1) && !strcmp(argv[1], "--no-output-files");
    if(!noOutputFiles) {
        char fileName[] = "c:/temp/Muxer_out.mp4";
        muxer = new MediaMuxer(fileName, MediaMuxer::OUTPUT_FORMAT_MPEG_4);
    }
    //MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER new MediaMuxer()", 3,0,-1);
    err = runEncoder(encoder, muxer);
    //MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER runEncoder()", 3,0,-1);
    if (err != NO_ERROR) {
        NN_LOG("RunEncoder failed (err=%d)\n", err);
        encoder->release();
    }

    // release encoder, muxer
    NN_LOG("Release Encoder here\n");
    if (encoder != NULL) encoder->release();
    //MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER encoder->release()", 3,0,-1);
    if (muxer != NULL) {
        muxer->stop();
    }
#ifndef RAPTOR_ENHANCEMENT
    MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER muxer->stop()", 3,0,-1);
    SfGlobal::FreeGlobal();
#endif
    //MV_check("MediaCodec Encoder API MEMORY PROFILE AFTER FreeGlobal()", 3,0,-1);
    //shutdownWebFrame();
    //MV_HeapDestroy(eMVHeapNN);
    SUCCEED();
}


// ------------------------------------------
// fake Linux APIs
//
// These are all Linux OS APIs that are called by various Stagefright functions.
// Most don't really do much other than optimize things Horizon can't optimize,
// so let's NULL them out, with a minor LOG message so we can gauge if the
// above assumption is actually true.
//
// Probably should eventually move to a 'NxPort' library or something
//
// Most of these are called in : android5_1\frameworks\av\media\libstagefright\webm/WebmElement.cpp:118
// ---------------------------------------------------------------

long sysconf(int name)
{
    NN_LOG("*** Calling unsupported : %s()\n",__FUNCTION__);
    return 0;
}
void *mmap(void *addr, size_t length, int prot, int flags, int fd, off_t offset)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return (void*) - 1;
}

int munmap(void *addr, size_t length)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return -1;
}

int msync(const void *addr, size_t length, int flags)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return -1;
}

int fcntl(int fildes, int cmd, ...)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return -1;
}

int prctl(int option, ...)
{
    NN_LOG("*** Calling unsupported :  %s() v1\n",__FUNCTION__);
    return -1;
}

int prctl(int option, unsigned long arg2, unsigned long arg3,
unsigned long arg4, unsigned long arg5)
{
    NN_LOG("*** Calling unsupported :  %s() v2\n",__FUNCTION__);
    return -1;
}

int dup(int oldfd)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return -1;
}

int pthread_attr_setdetachstate(pthread_attr_t *attr, int detachstate)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return -1;
}

int msync(void *addr, size_t length, int flags)
{
    NN_LOG("*** Calling unsupported :  %s()\n",__FUNCTION__);
    return -1;
}
