﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <functional>
#include <memory>

namespace movie { namespace sample {

    struct thread_wrapper {

        std::unique_ptr<char[]> thread_stack_;
        std::function<void()> func_;
        nn::os::ThreadType thread_;

        template <typename F>
        thread_wrapper(F func, size_t _4k_pages = 8) : func_{std::move(func)}
        {
            auto stack_size = _4k_pages * nn::os::ThreadStackAlignment + nn::os::ThreadStackAlignment;
            thread_stack_.reset( new char[stack_size] );

            void* orig_ptr_ = thread_stack_.get();
            void* adjusted_ptr_ = std::align(nn::os::ThreadStackAlignment, _4k_pages * nn::os::ThreadStackAlignment,
                                             orig_ptr_, stack_size);
            nn::os::CreateThread(&thread_,
                                 [](void* f_){ (*reinterpret_cast<decltype(func_)*>(f_))(); },
                                 std::addressof(func_),
                                 adjusted_ptr_,
                                 stack_size,
                                 nn::os::DefaultThreadPriority);


            nn::os::StartThread(&thread_);
        }

        thread_wrapper(thread_wrapper&& o) = delete;
        thread_wrapper& operator=(thread_wrapper&&) = delete;

        ~thread_wrapper() {
            nn::os::WaitThread(&thread_);
            nn::os::DestroyThread(&thread_);
        }

    };


}} // namespces
