﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <utility>

#include <nn/nn_Macro.h>

namespace movie { namespace sample {

    class ScopeExit {

        std::function<void()> on_exit_;
        bool is_set_;

        ScopeExit& operator=(ScopeExit&&) = delete;

    public:
        ScopeExit()
            : on_exit_{ []() {} }
            , is_set_{ false }
        {}

        NN_IMPLICIT template <typename F> ScopeExit(F&& func)
            : on_exit_{ std::forward<F>(func) }
            , is_set_{ true }
        {}

        ScopeExit(ScopeExit&& other) : ScopeExit()
        {
            swap(*this, other);
        }

        friend void swap(ScopeExit& this_, ScopeExit& other_) {
            std::swap(this_.on_exit_, other_.on_exit_);
            std::swap(this_.is_set_, other_.is_set_);
        }

        template <typename F>
        void TrySetExit(F&& func)
        {
            if (!is_set_) {
                on_exit_ = std::forward<F>(func);
                is_set_ = true;
            }
        }

        ~ScopeExit()
        {
            if (is_set_) { on_exit_(); }
        }
    };

}}
