﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_log.h>
#include "BlitVicSurface.h"

NvError InitializeSurface(NvRmSurface* pOutSurface, NvRmDeviceHandle device, std::uint32_t width, std::uint32_t height)
{
    NN_LOG("InitializeSurface: width = %u, height = %u\n", width, height);
    std::uint32_t attributes[] =
    {
        // VIC is optimized for block linear layout (see nvrm_surface.h)
        NvRmSurfaceAttribute_Layout, NvRmSurfaceLayout_Blocklinear,
        // Surface is not in a video protected region -- doesn't really make a difference in these tests
        NvRmSurfaceAttribute_Vpr, NV_FALSE,
        // Compression is disabled for this surface -- doesn't really make a difference in these tests
        NvRmSurfaceAttribute_Compression, NV_FALSE,
        // Terminator
        NvRmSurfaceAttribute_None
    };

    NvRmSurfaceSetup(pOutSurface, width, height, NvColorFormat_A8R8G8B8, attributes);

    std::uint32_t alignment = NvRmSurfaceComputeAlignment(nullptr, pOutSurface);
    std::uint32_t size = NvRmSurfaceComputeSize(pOutSurface);

    NVRM_DEFINE_MEM_HANDLE_ATTR(memAttributes);
    NVRM_MEM_HANDLE_SET_ATTR(memAttributes,
                             alignment,
                             NvOsMemAttribute_WriteBack,
                             size,
                             NVRM_MEM_TAG_DISPLAY_MISC);

    return NvRmMemHandleAllocAttr(device, &memAttributes, &pOutSurface->hMem);
}

bool FillSurface(NvRmSurface* pSurface, std::uint32_t color)
{
    std::uint32_t size = NvRmSurfaceComputeSize(pSurface);
    const size_t pixelCount = size / sizeof(std::uint32_t);
    std::uint32_t* pPixels = new std::uint32_t[pixelCount];

    if ( pPixels == nullptr )
    {
        return false;
    }

    for ( size_t i = 0; i < pixelCount; ++i )
    {
        *(pPixels + i) = color;
    }

    NvRmSurfaceWrite(pSurface, 0, 0, pSurface->Width, pSurface->Height, pPixels);

    delete [] pPixels;

    return true;
}
