﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/nntest.h>

#include <nn/migration/migration_UserMigrationApi.h>
#include <nn/migration/migration_UserMigrationApiPrivate.h>
#include <nn/migration/migration_UserMigrationServiceResource.h>
#include <nn/migration/detail/migration_SubsystemInitializer.h>
#include <nn/migration/idc/detail/migration_EncryptionPolicy.h>

#include "nntMigration_Account.h"
#include "nntMigration_ConnectionPolicy.h"
#include "nntMigration_RamStorage.h"

template <typename ImplConfiguration>
class StandaloneMigrationService
{
private:
    typedef nn::migration::UserMigrationServiceResource<ImplConfiguration> Resource;

    static std::aligned_storage<sizeof(nn::migration::detail::SubsystemInitializer), std::alignment_of<nn::migration::detail::SubsystemInitializer>::value>::type s_SubInitStorage;
    static nn::migration::detail::SubsystemInitializer* s_pSubInit;

    static typename std::aligned_storage<sizeof(Resource), std::alignment_of<Resource>::value>::type s_ResourceStorage;
    static nn::migration::UserMigrationRuntimeConfiguration s_RuntimeConfig;
    static Resource* s_pResource;

    static nn::sf::SharedPointer<nn::migration::user::IService> ObjectGetter() NN_NOEXCEPT
    {
        return s_pResource->GetServiceImpl();
    }

public:
    static void Initialize(
        const char* threadName,
        void* threadStack, size_t threadStackSize,
        void* loginBuffer, size_t loginBufferSize) NN_NOEXCEPT
    {
        s_pSubInit = new(&s_SubInitStorage)nn::migration::detail::SubsystemInitializer;

        nnt::migration::CleanupUsers();
        nnt::migration::SetupUser("moriyotd1", "N1ntend0");

        nn::migration::UserMigrationRuntimeConfiguration config = {
            threadName,
            nn::os::DefaultThreadPriority,
            threadStack,
            threadStackSize,
            loginBuffer,
            loginBufferSize,
        };
        s_RuntimeConfig = config;
        s_pResource = new(&s_ResourceStorage)Resource(s_RuntimeConfig);
        nn::migration::DebugSetUserMigrationInitializer(ObjectGetter);
    }
    static void Finalize() NN_NOEXCEPT
    {
        s_pSubInit->~SubsystemInitializer();

        nn::migration::DebugResetUserMigrationServiceAccessor();
        s_pResource->~UserMigrationServiceResource();
        nnt::migration::CleanupUsers();
    }
};

class SharedBufferSequenceTest
    : public testing::Test
{
private:
    struct StateStorageTag { static const char VolumeName[]; };
    struct ServerStorageTag { static const char VolumeName[]; };
    struct ClientStorageTag { static const char VolumeName[]; };

    struct ImplConfiguration {
        typedef nnt::migration::RamStoragePolicy<StateStorageTag> StateStoragePolicy;
        typedef nn::migration::user::Server<
            nnt::migration::RamStoragePolicy<ServerStorageTag>,
            nnt::migration::InprocessConnectionPolicy,
            nn::migration::idc::detail::DebugEncryptionPolicy,
            nnt::migration::IdcSubsystemInitializer> ServerImpl;
        typedef nn::migration::user::Client<
            nnt::migration::RamStoragePolicy<ClientStorageTag>,
            nnt::migration::InprocessConnectionPolicy,
            nn::migration::idc::detail::DebugEncryptionPolicy,
            nnt::migration::IdcSubsystemInitializer> ClientImpl;
    };

    typedef StandaloneMigrationService<ImplConfiguration> Service;

public:
    SharedBufferSequenceTest() NN_NOEXCEPT
    {
        nnt::migration::RamStoragePolicy<StateStorageTag>::Storage().Cleanup();
        nnt::migration::RamStoragePolicy<ServerStorageTag>::Storage().Cleanup();
        nnt::migration::RamStoragePolicy<ClientStorageTag>::Storage().Cleanup();
    }
protected:
    static void SetUpTestCase() NN_NOEXCEPT;
    static void TearDownTestCase() NN_NOEXCEPT;
};

class SocketSequenceTest
    : public testing::Test
{
private:
    struct StateStorageTag { static const char VolumeName[]; };
    struct ServerStorageTag { static const char VolumeName[]; };
    struct ClientStorageTag { static const char VolumeName[]; };

    struct ImplConfiguration {
        typedef nnt::migration::RamStoragePolicy<StateStorageTag> StateStoragePolicy;
        typedef nn::migration::user::Server<
            nnt::migration::RamStoragePolicy<ServerStorageTag>,
            nnt::migration::LocalhostConnectionPolicy,
            nn::migration::idc::detail::DebugEncryptionPolicy,
            nnt::migration::NoSubsystemInitializer> ServerImpl;
        typedef nn::migration::user::Client<
            nnt::migration::RamStoragePolicy<ClientStorageTag>,
            nnt::migration::LocalhostConnectionPolicy,
            nn::migration::idc::detail::DebugEncryptionPolicy,
            nnt::migration::NoSubsystemInitializer> ClientImpl;
    };

    typedef StandaloneMigrationService<ImplConfiguration> Service;

public:
    SocketSequenceTest() NN_NOEXCEPT
    {
        nnt::migration::RamStoragePolicy<StateStorageTag>::Storage().Cleanup();
        nnt::migration::RamStoragePolicy<ServerStorageTag>::Storage().Cleanup();
        nnt::migration::RamStoragePolicy<ClientStorageTag>::Storage().Cleanup();
    }
protected:
    static void SetUpTestCase() NN_NOEXCEPT;
    static void TearDownTestCase() NN_NOEXCEPT;
};

class ProductSequenceTest
    : public testing::Test
{
protected:
    static void SetUpTestCase() NN_NOEXCEPT;
    static void TearDownTestCase() NN_NOEXCEPT;
};

// 実装

template <typename ImplConfiguration>
std::aligned_storage<sizeof(nn::migration::detail::SubsystemInitializer), std::alignment_of<nn::migration::detail::SubsystemInitializer>::value>::type StandaloneMigrationService<ImplConfiguration>::s_SubInitStorage;
template <typename ImplConfiguration>
nn::migration::detail::SubsystemInitializer* StandaloneMigrationService<ImplConfiguration>::s_pSubInit;

template <typename ImplConfiguration>
typename std::aligned_storage<sizeof(typename StandaloneMigrationService<ImplConfiguration>::Resource), std::alignment_of<typename StandaloneMigrationService<ImplConfiguration>::Resource>::value>::type StandaloneMigrationService<ImplConfiguration>::s_ResourceStorage;
template <typename ImplConfiguration>
nn::migration::UserMigrationRuntimeConfiguration StandaloneMigrationService<ImplConfiguration>::s_RuntimeConfig;
template <typename ImplConfiguration>
typename StandaloneMigrationService<ImplConfiguration>::Resource* StandaloneMigrationService<ImplConfiguration>::s_pResource;
