﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUserMigrationSequence_Facets.h"
#include "testUserMigrationSequence_TestBasic.h"
#include "testUserMigrationSequence_Util.h"

#include <curl/curl.h>

#include <nnt.h>
#include <nnt/nnt_Argument.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

#include <nn/nn_Abort.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <nn/friends/friends_Api.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/npns/npns_ApiSystem.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/os/os_Thread.h>
#include <nn/ovln/ovln_ForDevelop.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/pdm/pdm_NotifyEventApi.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/spl/spl_Api.h>
#include <nn/time/time_Api.h>

namespace {
#if defined(NNT_MIGRATION_ZWITTER)
bool g_ServerResult;

static void ThreadFunction(void* data) NN_NOEXCEPT
{
    NN_UNUSED(data);

    PAGE_ALIGN static char g_ServerWorkMemory[32 * 1024 * 1024];
    g_ServerResult = RunServer(g_ServerWorkMemory, sizeof(g_ServerWorkMemory));
}

void RunBasicZwitterTest() NN_NOEXCEPT
{
    PAGE_ALIGN static char g_ClientWorkMemory[32 * 1024 * 1024];
    PAGE_ALIGN static char g_ThreadStack[128 * 1024];

    nn::migration::CleanupUserMigration(g_ClientWorkMemory, sizeof(g_ClientWorkMemory));
    auto lastState = nn::migration::GetLastUserMigrationState();
    ASSERT_TRUE(lastState == nn::migration::LastUserMigrationState::Unresumable);

    nn::os::ThreadType thread;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&thread, ThreadFunction, nullptr, g_ThreadStack, sizeof(g_ThreadStack), nn::os::DefaultThreadPriority));
    nn::os::StartThread(&thread);
    NN_UTIL_SCOPE_EXIT
    {
        nn::os::WaitThread(&thread);
        nn::os::DestroyThread(&thread);
    };
    ASSERT_TRUE(RunClient("atd1001", "N1ntend0", g_ClientWorkMemory, sizeof(g_ClientWorkMemory)));
    NN_ABORT_UNLESS(g_ServerResult);
}
#else
#endif
} // ~namespace <anonoymous>


#if defined(NNT_MIGRATION_ZWITTER)
TEST_F(SharedBufferSequenceTest, BasicZwitterTest)
{
    RunBasicZwitterTest();
}
#endif // defined(NNT_MIGRATION_ZWITTER)

#if defined(NNT_MIGRATION_ZWITTER)
TEST_F(SocketSequenceTest, BasicZwitterTest)
{
    RunBasicZwitterTest();
}
#endif // defined(NNT_MIGRATION_ZWITTER)

#if !defined(NNT_MIGRATION_ZWITTER)
#if defined(NNT_MIGRATION_SERVER)
TEST_F(ProductSequenceTest, BasicServerTest)
{
    auto lastState = nn::migration::GetLastUserMigrationState();
    ASSERT_TRUE(lastState == nn::migration::LastUserMigrationState::Unresumable);

    PAGE_ALIGN static char g_ServerWorkMemory[32 * 1024 * 1024];
    ASSERT_TRUE(RunServer(g_ServerWorkMemory, sizeof(g_ServerWorkMemory)));
}
#elif defined(NNT_MIGRATION_CLIENT)
TEST_F(ProductSequenceTest, BasicServerClient)
{
    auto lastState = nn::migration::GetLastUserMigrationState();
    ASSERT_TRUE(lastState == nn::migration::LastUserMigrationState::Unresumable);

    PAGE_ALIGN static char g_ClientWorkMemory[32 * 1024 * 1024];
    ASSERT_TRUE(RunClient("moriyotd1", "N1ntend0", g_ClientWorkMemory, sizeof(g_ClientWorkMemory)));
}
#endif // defined(NNT_MIGRATION_SERVER) || defined(NNT_MIGRATION_CLIENT)
#endif // !defined(NNT_MIGRATION_ZWITTER)

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    testing::InitGoogleTest(&argc, argv);
    testing::TestEventListeners& listeners = ::testing::UnitTest::GetInstance()->listeners();
    testing::TestEventListener* defaultResultPrinter = listeners.Release(listeners.default_result_printer());
    listeners.Append(new nnt::teamcity::ServiceMessageLogger());
    listeners.Append(defaultResultPrinter);

    static nn::socket::SystemConfigDefaultWithMemory<2, 0, 2> s_SocketConfig(2);

    // サブシステムの初期化
    nn::account::InitializeForAdministrator();
    nn::friends::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::InitializeSystem());
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::socket::Initialize(s_SocketConfig));
    NN_ABORT_UNLESS(curl_global_init(CURL_GLOBAL_ALL) == CURLE_OK);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::npns::InitializeForSystem());
    nn::pdm::InitializeForNotification();
    nn::spl::InitializeForCrypto();
#else
    nn::ncm::Initialize();
    nn::ovln::PrepareSenderAndReceiverForDevelop();
    nn::ovln::InitializeSenderLibraryForOverlay();
    nn::nim::InitializeForNetworkInstallManager();
#endif // defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::ns::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::time::Initialize());

    auto result = RUN_ALL_TESTS();
    nnt::Exit(result);
}
