﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/os.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/time/time_Api.h>
#include <nn/util/util_StringUtil.h>

#if defined (NN_BUILD_CONFIG_OS_HORIZON)
#include <nn/spl/spl_Api.h>
#endif

#include "testMigrationIdc_SequenceClient.h"
#include "testMigrationIdc_SequenceServer.h"

void LogUsage()
{
    NN_LOG("Usage : *.exe server\n");
    NN_LOG("      : *.exe client <ip> <port>\n");
}

extern "C" void nnMain()
{
    int     argc = nn::os::GetHostArgc();
    char**  argv = nn::os::GetHostArgv();

    for(int i = 0; i < argc; i++)
    {
        NN_LOG("nnMain : argv[%d] %s\n", i, argv[i]);
    }

    if( argc < 2 )
    {
        LogUsage();
        return;
    }

    static nn::socket::ConfigDefaultWithMemory s_SocketConfig;

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::InitializeSystem());
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::socket::Initialize(s_SocketConfig));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::time::Initialize());

    nn::nifm::SubmitNetworkRequestAndWait();
    NN_ABORT_UNLESS(nn::nifm::IsNetworkAvailable());

#if defined (NN_BUILD_CONFIG_OS_HORIZON)
    nn::spl::InitializeForCrypto();
#endif

    if( nn::util::Strncmp(argv[1], "server", static_cast<int>(std::strlen("server"))) == 0 )
    {
        RunServer();
    }
    else if( nn::util::Strncmp(argv[1], "client", static_cast<int>(std::strlen("client"))) == 0 )
    {
        if( argc <= 3 )
        {
            LogUsage();
            return;
        }

        const char* addressString = argv[2];
        const char* portString = argv[3];

        uint16_t port = static_cast<uint16_t>(atoi(portString));

        RunClient(addressString, port);
    }
    else
    {
        LogUsage();
    }
}
