﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/migration/idc/migration_KeyExchangeCommandEncryptor.h>
#include <nn/migration/idc/migration_MessageEncryptor.h>

namespace nnt { namespace migration {

template <size_t BlockSize>
struct NoEncryptionPolicy
{
    typedef nn::migration::idc::DebugKeyExchangeCommandEncryptor KeyEncryptor;
    typedef nn::migration::idc::DebugMessageEncryptor MessageEncryptor;
    static const size_t UserCommandBlockSize = BlockSize;
    static const int KeyStretchingIteration = 1000;
    static const nn::migration::idc::KeyExchangeCommandConfig::Salt KeyStretchingSalt;
};

template <size_t BlockSize>
const nn::migration::idc::KeyExchangeCommandConfig::Salt NoEncryptionPolicy<BlockSize>::KeyStretchingSalt = {};

#if defined(NN_BUILD_TARGET_PLATFORM_NX)

template <size_t BlockSize>
struct MessageOnlyEncryptionPolicy
{
    typedef nn::migration::idc::DebugKeyExchangeCommandEncryptor KeyEncryptor;
    typedef nn::migration::idc::MessageEncryptor MessageEncryptor;
    static const size_t UserCommandBlockSize = BlockSize;
    static const int KeyStretchingIteration = 1000;
    static const nn::migration::idc::KeyExchangeCommandConfig::Salt KeyStretchingSalt;
};

template <size_t BlockSize>
const nn::migration::idc::KeyExchangeCommandConfig::Salt MessageOnlyEncryptionPolicy<BlockSize>::KeyStretchingSalt = {};

#endif

}} // ~namespace nnt::migration
