﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <memory>

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>

namespace nnt { namespace migration {

class Buffer
{
    NN_DISALLOW_COPY(Buffer);
    NN_DISALLOW_MOVE(Buffer);
private:
    std::unique_ptr<char[]> pointer;
    size_t size;
public:
    explicit Buffer(size_t s) NN_NOEXCEPT
        : pointer(reinterpret_cast<char*>(std::malloc(s)))
        , size(s)
    {
        NN_ABORT_UNLESS(pointer);
        NN_ABORT_UNLESS(s > 0);
    }
    void* GetPointer() const NN_NOEXCEPT
    {
        return pointer.get();
    }
    template <typename T>
    T* Get() const NN_NOEXCEPT
    {
        return reinterpret_cast<T*>(GetPointer());
    }
    size_t GetSize() const NN_NOEXCEPT
    {
        return size;
    }
};

}} // ~namespace nnt::migration
