﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <random>

#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/init.h>

#define ASSERT_NOT_NULL(p) ASSERT_TRUE(p != nullptr)

// InitializeAllocator が動くか確認
extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(nullptr, 62ull * 1024 * 1024 * 1024);
}

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
/**
 * @brief   malloc の確認です。
 */
TEST(VammMallocTest, Malloc)
{
    const int Seed = 12345;
    const int AllocateCount = 1000;
    const int LoopCount = 100;
    std::mt19937 engine(Seed);
    std::uniform_int_distribution<uint32_t> exponent(3, 20);
    std::uniform_int_distribution<uint32_t> fluctuation(0, 256);

    NN_LOG("Seed : %d\n", Seed);

    void* pAddr[AllocateCount];
    for (int i = 0; i < LoopCount; ++i)
    {
        for (int j = 0; j < AllocateCount; ++j)
        {
            size_t allocateSize = static_cast<size_t>(std::pow(2, exponent(engine))) + fluctuation(engine);
            pAddr[j] = std::malloc(allocateSize);
            ASSERT_NOT_NULL(pAddr[j]) << "pAddr[" << j << "]: " << pAddr[j];
        }
        for (int j = 0; j < AllocateCount; ++j)
        {
            std::free(pAddr[j]);
        }
    }
}

/**
 * @brief   new の確認です。
 */
TEST(VammMallocTest, New)
{
    const int Seed = 12345;
    const int AllocateCount = 1000;
    const int LoopCount = 100;
    std::mt19937 engine(Seed);
    std::uniform_int_distribution<uint32_t> exponent(3, 20);
    std::uniform_int_distribution<uint32_t> fluctuation(0, 256);

    NN_LOG("Seed : %d\n", Seed);

    char* pAddr[AllocateCount];
    for (int i = 0; i < LoopCount; ++i)
    {
        for (int j = 0; j < AllocateCount; ++j)
        {
            size_t allocateSize = static_cast<size_t>(std::pow(2, exponent(engine))) + fluctuation(engine);
            pAddr[j] = new char[allocateSize];
            ASSERT_NOT_NULL(pAddr[j]) << "pAddr[" << j << "]: " << pAddr[j];
        }
        for (int j = 0; j < AllocateCount; ++j)
        {
            delete[] pAddr[j];
        }
    }
}
#endif  // #if defined(NN_BUILD_CONFIG_OS_HORIZON)

