﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/nn_Assert.h>
#include <nnt/nnt_Argument.h>

#include <nn/init.h>
#include <nn/mem.h>

extern "C" void nninitStartup()
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::SetMemoryHeapSize(384 * 1024 * 1024));

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    // Horizon でテストする場合 fs アロケータ用の malloc 領域が必要
    uintptr_t address;
    const size_t fsAlloctorSize = 2 * 1024 * 1024;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::AllocateMemoryBlock(&address, fsAlloctorSize));
    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), fsAlloctorSize);
#endif
}

extern "C" void nnMain()
{
    int    argc = nnt::GetHostArgc();
    char** argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    // TeamCity の表示を適切にするため、イベントリスナの登録を一旦すべて解除し、
    // ServiceMessageLogger -> デフォルトのイベントリスナ の順で登録し直す。
    ::testing::TestEventListeners& listeners = ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter = listeners.Release(listeners.default_result_printer());
    listeners.Append(new nnt::teamcity::ServiceMessageLogger());
    listeners.Append(defaultResultPrinter);

    int testResult = RUN_ALL_TESTS();

    nnt::Exit( testResult );
}
