﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <nn/nn_Common.h>

NN_STATIC_ASSERT(RAND_MAX >= 0xffff);

inline uint32_t Rand32()
{
    uint32_t l = rand() & 0xffff;
    uint32_t h = rand() & 0xffff;
    return (h << 16) | l;
}
