﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/pinmux/pinmux.h>
#include <nn/pinmux/pinmux_ApiForHardwareTest.h>

TEST(BoardWirelessTest, SkipFlag)
{
    //WLAN SkipFlag
    bool isSkipBoot = true;
    nn::settings::fwdbg::GetSettingsItemValue(&isSkipBoot, sizeof(isSkipBoot), "wlan_debug", "skip_wlan_boot");
    EXPECT_FALSE(isSkipBoot);

    //BT SkipFlag
    nn::settings::fwdbg::GetSettingsItemValue(&isSkipBoot, sizeof(isSkipBoot), "bluetooth_debug", "skip_boot");
    EXPECT_FALSE(isSkipBoot);
}

//Pinmuxの権限が必要
//TEST(BoardWirelessTest, Pinmux)
//{
//  //BT Pinmux Setup
//  nn::pinmux::Initialize();
//
//  nn::pinmux::PinmuxSession session[1];
//
//  nn::pinmux::OpenSessionForHardwareTest(session, nn::pinmux::AssignablePinGroupNameForHardwareTest_UartD);
//  nn::pinmux::SetPinAssignmentForHardwareTest(session, nn::pinmux::PinAssignmentForHardwareTest_UartDHiZ);
//  nn::pinmux::CloseSessionForHardwareTest(session);
//
//  nn::pinmux::Finalize();
//}
