﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_Log.h>
#include <nn/ldn.h>
#include <nn/os.h>
#include <nn/socket/socket_Api.h>
#include <nn/util/util_FormatString.h>

namespace
{
    const int       LogBufferCount = 8;
    const size_t    LogBufferSize = 256;
    char            g_LogBuffers[LogBufferCount][LogBufferSize];
    int             g_LogIndex = 0;
    nn::os::Mutex   g_Mutex(false);

    char* GetBuffer() NN_NOEXCEPT
    {
        std::lock_guard<nn::os::Mutex> lock(g_Mutex);
        int index = g_LogIndex;
        g_LogIndex = (g_LogIndex + 1) % LogBufferCount;
        return g_LogBuffers[index];
    }
}

const char* ConvertToString(const nn::ldn::Ipv4Address& ipv4Address) NN_NOEXCEPT
{
    uint32_t address = nn::socket::InetHtonl(ipv4Address.raw);
    const uint8_t* p = reinterpret_cast<uint8_t*>(&address);
    char* buffer = GetBuffer();
    nn::util::SNPrintf(buffer, LogBufferSize, "%d.%d.%d.%d", p[0], p[1], p[2], p[3]);
    return buffer;
}

const char* ConvertToString(const nn::ldn::SubnetMask& subnetMask) NN_NOEXCEPT
{
    uint32_t mask = nn::socket::InetHtonl(subnetMask.raw);
    const uint8_t* p = reinterpret_cast<uint8_t*>(&mask);
    char* buffer = GetBuffer();
    nn::util::SNPrintf(buffer, LogBufferSize, "%d.%d.%d.%d", p[0], p[1], p[2], p[3]);
    return buffer;
}


