﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/ldn.h>
#include "Types.h"


const char strInit[InitCount][BufferSize] =
{
    "Start AP mode",
    "Start STA mode",
    "Setting",
    "Exit"
};

const char strSetting[SettingCount][BufferSize] =
{
    "LDN SETTING",
    "SEND PACKET SETTING"
};

const char strLdnParameter[LdnParameterCount][BufferSize] =
{
    "Ldn Group :",
    "Ldn Mode :",
    "FrequencyBand :",
    "Channel :",
    "Security :",
    "NodeCountMax :",
};

const char strPacketParameter[PacketParameterCount][BufferSize] =
{
    "Cast To :",
    "Rate(/sec) :",
    "PacketSize(Byte) :"
};

const char strSettingGroup[5][BufferSize] =
{
    "A",
    "B",
    "C",
    "D",
    "E"
};

const char strSettingMode[2][BufferSize] =
{
    "AP mode",
    "STA mode"
};

const char strSettingBand[2][BufferSize] =
{
    "5GHz",
    "2.4GHz"
};

const char strSettingChannnel5g[4][BufferSize] =
{
    "36",
    "40",
    "44",
    "48"
};

const char strSettingChannnel2g[3][BufferSize] =
{
    "1",
    "6",
    "11"
};

const char strSettingSecurity[2][BufferSize] =
{
    "StaticAES",
    "None"
};

const char strSettingCastTo[4][BufferSize] =
{
    "Broadcast",
    "Unicast to AP",
    "Unicast to All",
    "Ping to All"
};

void DisplayInfo(ApplicationResource app) NN_NOEXCEPT;
