﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <random>

namespace
{
    std::mt19937 g_Random;

} // namespace ::<unnamed>

int Random(int min, int max) NN_NOEXCEPT
{
    std::uniform_int_distribution<> dist(min, max);
    return dist(g_Random);
}

void SetSeed(int seed) NN_NOEXCEPT
{
    g_Random.seed(static_cast<unsigned long>(seed));
}
