﻿# コマンドラインツールのパスを設定します。
$CommandLineTools = "$SIGLO_ROOT\Tools\CommandLineTools"
if ($AUTHORING_TOOL -eq $NULL)
{
    Set-Variable AUTHORING_TOOL `
        "$CommandLineTools\AuthoringTool\AuthoringTool.exe" `
        -Option Constant -Scope Script
}

# Authoring を行います。
Function Authoring()
{
    # AuthoringTool.exe の存在を確認します。   
    if (!(Test-Path $AUTHORING_TOOL))
    {
        throw 'AuthoringTool が見つかりません。'
    }
    Write-Host "AuthoringTool $Args"
    $StdOut = &$AUTHORING_TOOL $Args
}

# システムデータを生成します。
Function MakeSystemData()
{
    Authoring creatensp `
        --type SystemData `
        @Args `
        --keyconfig $CommandLineTools\AuthoringTool\AuthoringTool.repository.keyconfig.xml
}

# システムアップデートを生成します。
Function MakeSystemUpdate()
{
    Authoring creatensp `
        --type SystemUpdate `
        @Args `
        --keyconfig $CommandLineTools\AuthoringTool\AuthoringTool.repository.keyconfig.xml
}
