﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_Api.h>
#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/nifm/nifm_ApiCommunicationControlForTest.h>
#include <nn/nifm/nifm_ApiForTest.h>
#include <nn/os.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nnt/nntest.h>
#include <nnt/ldn/testLdn_NifmUtility.h>
#include <nnt/result/testResult_Assert.h>

namespace nnt { namespace ldn
{
    void InitializeNifm() NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::Initialize());

        const bool isEnabled = true;
        nn::settings::fwdbg::SetSettingsItemValue(
            "nifm", "is_communication_control_enabled_for_test", &isEnabled, sizeof(isEnabled));
    }

    void FinalizeNifm() NN_NOEXCEPT
    {
    }

    void SetWirelessCommunicationSwitch(bool isEnabled) NN_NOEXCEPT
    {
        nn::nifm::SetWirelessCommunicationEnabledForTest(isEnabled);
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(2));
    }

    void PutSleep() NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::PutToSleep());
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }

    void WakeUp() NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::WakeUp());
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }

    void LockNifm() NN_NOEXCEPT
    {
        nn::nifm::ClientId clientId = nn::nifm::GetClientId();
        clientId.value += 1000000;
        NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetExclusiveClient(clientId));
    }

    void UnlockNifm() NN_NOEXCEPT
    {
        nn::nifm::ClientId invalidClientId = { nn::nifm::InvalidClientIdValue };
        nn::nifm::SetExclusiveClient(invalidClientId);
    }

}} // namespace nnt::ldn
