﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nnt/lcs/testLcs_TestApplications.h>

//! デフォルトでテストに使用するアプリケーションです。
const auto DefaultApplicationId = nnt::lcs::Application::Matching01;

//! 接続待ちのタイムアウト時間です。
const nn::TimeSpan JoinTimeout = nn::TimeSpan::FromSeconds(5);

//! スキャン待ちのタイムアウト時間です。
const nn::TimeSpan ScanTimeout = nn::TimeSpan::FromSeconds(8);

//! 切断後反応待ちのタイムアウト時間です。
const nn::TimeSpan LeaveReactionTimeout = nn::TimeSpan::FromSeconds(10);

//! 状態変化待ちのタイムアウト時間です。
const nn::TimeSpan StateChangeTimeout = nn::TimeSpan::FromSeconds(1);

//! 配信完了待ちのタイムアウト時間です。
const nn::TimeSpan ShareCompleteTimeout = nn::TimeSpan::FromSeconds(300);

//! テストを繰り返す回数です。
const int RepeatCount = 8;

//! LUP を含むテストを繰り返す回数です。
const int LupRepeatCount = 4;
