﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/lcs/testLcs_Utility.h>

void SetSystemDeliveryProtocolPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test) NN_NOEXCEPT
{
    auto& source = *pSource;
    if (std::strcmp(test, "HostIsHigherVersion") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
        source.SetSystemDeliveryProtocolVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "HostIsLowerVersion") == 0)
    {
        source.SetSystemVersion(1, 3, 2);
        source.SetSystemDeliveryProtocolVersion(1, 3, 2);
    }
    else
    {
        NN_ABORT("Unknown Test: SystemDeliveryProtocol.%s\n", test);
    }
}

void SetApplicationIdAndVersion(
    nnt::lcs::PreconditionSource* pSource,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    source.application.id = applicationId;
    if (applicationId == nnt::lcs::Application::SystemDeliveryProtocol01)
    {
        source.SetApplicationVersion(2, 1, 1);
    }
    else if (applicationId == nnt::lcs::Application::SystemDeliveryProtocol02)
    {
        source.SetApplicationVersion(1, 2, 3);
    }
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    SetApplicationIdAndVersion(&source, applicationId);
    if (std::strcmp(testcase, "SystemDeliveryProtocol") == 0)
    {
        SetSystemDeliveryProtocolPrecondition(&source, test);
    }
    else
    {
        NN_ABORT("Unknown Testcase: %s\n", testcase);
    }
    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
