﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/lcs/testLcs_Utility.h>

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    NN_UNUSED(test);

    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    source.application.id = applicationId;
    if (applicationId == nnt::lcs::Application::Matching01)
    {
        source.SetApplicationVersion(1);
    }
    else if (applicationId == nnt::lcs::Application::Matching02)
    {
        source.SetApplicationVersion(2);
    }
    else if (applicationId == nnt::lcs::Application::Matching03)
    {
        source.SetApplicationVersion(1, 2, 3);
    }
    else if (applicationId == nnt::lcs::Application::Matching04)
    {
        source.SetApplicationVersion(3, 2, 1);
    }
    else if (applicationId == nnt::lcs::Application::Matching05)
    {
        source.SetApplicationVersion(1, 0, 0);
    }

    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
