﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/lcs/testLcs_Utility.h>

void SetApplicationIdAndVersion(
    nnt::lcs::PreconditionSource* pSource, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    auto& source = *pSource;
    source.application.id = applicationId;
    if (applicationId == nnt::lcs::Application::HostMigration01)
    {
        source.SetApplicationVersion(2, 1, 1);
    }
    else if (applicationId == nnt::lcs::Application::HostMigration02)
    {
        source.SetApplicationVersion(1, 2, 1);
    }
    else if (applicationId == nnt::lcs::Application::HostMigration03)
    {
        source.SetApplicationVersion(1, 1, 2);
    }
}

void SetSystemVersion(
    nnt::lcs::PreconditionSource* pSource, const char* test) NN_NOEXCEPT
{
    auto& source = *pSource;
    if (std::strcmp(test, "HostHasLatestSystem") == 0)
    {
        source.SetSystemVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "HostAndFirstClientHaveLatestSystem") == 0)
    {
        source.SetSystemVersion(2, 2, 1);
    }
    else if (std::strcmp(test, "FirstClientHasLatestSystem") == 0)
    {
        source.SetSystemVersion(1, 2, 1);
    }
    else if (std::strcmp(test, "SomeClientsHaveLatestSystem") == 0)
    {
        source.SetSystemVersion(1, 1, 2);
    }
    else
    {
        NN_ABORT("Unknown Test: %s\n", test);
    }
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    NN_UNUSED(test);
    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    SetApplicationIdAndVersion(&source, applicationId);
    SetSystemVersion(&source, test);
    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
