﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nnt/lcs/testLcs_Utility.h>

void SetLupPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "PatchRequiredSystemVersion1") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetExFatDriverEnabled(false, true, true);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationRequiredSystemVersion(2, 1, 1);
    }
    else if (std::strcmp(test, "PatchRequiredSystemVersion2") == 0)
    {
        source.SetSystemVersion(1, 2, 2);
        source.SetExFatDriverEnabled(true, false, true);
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationRequiredSystemVersion(1, 1, 2);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion1") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetSystemRequiredSystemVersion(2, 1, 1);
        source.SetExFatDriverEnabled(false, true, true);
        source.SetApplicationVersion(2, 1, 3);
    }
    else if (std::strcmp(test, "LcsRequiredSystemVersion2") == 0)
    {
        source.SetSystemVersion(1, 2, 2);
        source.SetSystemRequiredSystemVersion(1, 2, 2);
        source.SetExFatDriverEnabled(true, false, true);
        source.SetApplicationVersion(1, 2, 1);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol1") == 0)
    {
        source.SetSystemVersion(1, 3, 2);
        source.SetExFatDriverEnabled(true, false, true);
        source.SetApplicationVersion(2, 1, 3);
        source.SetApplicationDeliveryProtocolVersion(1, 2, 2, false);
    }
    else if (std::strcmp(test, "ApplicationDeliveryProtocol2") == 0)
    {
        source.SetSystemVersion(2, 2, 1);
        source.SetExFatDriverEnabled(false, true, true);
        source.SetApplicationVersion(2, 1, 1);
        source.SetApplicationDeliveryProtocolVersion(2, 2, 1, false);
    }
    else
    {
        NN_ABORT("Unknown Test: ForkLup.%s\n", test);
    }
}

void SetPatchSharePrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test,
    nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "HostIsMaster") == 0)
    {
        source.SetSystemVersion(3, 2, 1);
        source.SetExFatDriverEnabled(false, false, true);
        source.SetApplicationVersion(2, 2, 1);
        source.SetApplicationRequiredSystemVersion(3, 1, 1);
    }
    else if (std::strcmp(test, "ClientIsMaster") == 0)
    {
        source.SetSystemVersion(2, 3, 1);
        source.SetExFatDriverEnabled(false, false, true);
        source.SetApplicationVersion(2, 2, 1);
        source.SetApplicationRequiredSystemVersion(1, 3, 1);
    }
    else
    {
        NN_ABORT("Unknown Test: ForkPatchShare.%s\n", test);
    }
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    NN_UNUSED(test);
    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    source.application.id = applicationId;
    if (std::strcmp(testcase, "ForkLup") == 0)
    {
        SetLupPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "ForkPatchShare") == 0)
    {
        SetPatchSharePrecondition(&source, test, applicationId);
    }
    else
    {
        NN_ABORT("Unknown Testcase: %s\n", testcase);
    }
    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
