﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/lcs.h>
#include <nn/lcs/lcs_DebugApi.h>
#include <nn/lcs/lcs_PrivateDebugApi.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/socket.h>
#include <nnt.h>
#include <nnt/lcs/testLcs_Utility.h>
#include <nnt/ldn/testLdn_HtcsSynchronization.h>
#include <nnt/ldn/testLdn_NifmUtility.h>
#include <nnt/ldn/testLdn_Utility.h>
#include <nnt/result/testResult_Assert.h>
#include "Precondition.h"

namespace
{
    // テストを実行するヘルパです。
    nnt::lcs::TestHelper* g_pHelper;

    // Socket の初期化用バッファです。
    nn::socket::ConfigDefaultWithMemory g_SocketConfig;

} // namespace <unnamed>

//
// Slave-Slave 間の LUP を行います.
// LUP の契機となるのは Patch Required System Version です。
//
TEST(ForkLup, PatchRequiredSystemVersion1)
{
    const auto cond = GetPrecondition(
        "ForkLup", "PatchRequiredSystemVersion1",
        nnt::lcs::Application::Fork01);
    g_pHelper->RunTest(cond, "ForkLup.PatchRequiredSystemVersion1", 3);
}

//
// Slave-Slave 間の LUP を行います.
// LUP の契機となるのは Patch Required System Version です。
//
TEST(ForkLup, PatchRequiredSystemVersion2)
{
    const auto cond = GetPrecondition(
        "ForkLup", "PatchRequiredSystemVersion2",
        nnt::lcs::Application::Fork01);
    g_pHelper->RunTest(cond, "ForkLup.PatchRequiredSystemVersion2", 3);
}

//
// Slave-Slave 間の LUP を行います.
// LUP の契機となるのは Required System Version to Deliver です。
//
TEST(ForkLup, LcsRequiredSystemVersion1)
{
    const auto cond = GetPrecondition(
        "ForkLup", "LcsRequiredSystemVersion1",
        nnt::lcs::Application::Fork02);
    g_pHelper->RunTest(cond, "ForkLup.LcsRequiredSystemVersion1", 3);
}

//
// Slave-Slave 間の LUP を行います.
// LUP の契機となるのは Required System Version to Deliver です。
//
TEST(ForkLup, LcsRequiredSystemVersion2)
{
    const auto cond = GetPrecondition(
        "ForkLup", "LcsRequiredSystemVersion2",
        nnt::lcs::Application::Fork02);
    g_pHelper->RunTest(cond, "ForkLup.LcsRequiredSystemVersion2", 3);
}

//
// Slave-Slave 間の LUP を行います.
// LUP の契機となるのは Application Delivery Protocol です。
//
TEST(ForkLup, ApplicationDeliveryProtocol1)
{
    const auto cond = GetPrecondition(
        "ForkLup", "ApplicationDeliveryProtocol1",
        nnt::lcs::Application::Fork02);
    g_pHelper->RunTest(cond, "ForkLup.ApplicationDeliveryProtocol1", 3);
}

//
// Slave-Slave 間の LUP を行います.
// LUP の契機となるのは Application Delivery Protocol です。
//
TEST(ForkLup, ApplicationDeliveryProtocol2)
{
    const auto cond = GetPrecondition(
        "ForkLup", "ApplicationDeliveryProtocol2",
        nnt::lcs::Application::Fork02);
    g_pHelper->RunTest(cond, "ForkLup.ApplicationDeliveryProtocol2", 3);
}

//
// Slave-Slave 間のパッチ配信を行います.
// Host がそのままマスターになります。
//
TEST(ForkPatchShare, HostIsMaster)
{
    const auto cond = GetPrecondition(
        "ForkPatchShare", "HostIsMaster",
        nnt::lcs::Application::Fork03);
    g_pHelper->RunTest(cond, "ForkPatchShare.HostIsMaster", 3);
}

//
// Slave-Slave 間のパッチ配信を行います.
// Client がマスターになります。
//
TEST(ForkPatchShare, ClientIsMaster)
{
    const auto cond = GetPrecondition(
        "ForkPatchShare", "ClientIsMaster",
        nnt::lcs::Application::Fork04);
    g_pHelper->RunTest(cond, "ForkPatchShare.ClientIsMaster", 3);
}

//
// テストのエントリポイントです。
//
extern "C" void nnMain()
{
    // コマンドライン引数に関する設定です。
    nnt::lcs::CommandLineParserSetting setting = { };
    setting.flag = static_cast<nn::Bit32>(
        nnt::lcs::CommandLineOptionFlag_NodeCount |
        nnt::lcs::CommandLineOptionFlag_NodeIndex |
        nnt::lcs::CommandLineOptionFlag_Resume |
        nnt::lcs::CommandLineOptionFlag_SceneId);
    setting.nodeCountMin = 2;
    setting.nodeCountMax = nnt::ldn::SynchronizationClientCountMax;

    // コマンドライン引数を解析します。
    nnt::lcs::TestConfig config;
    int argc = nn::os::GetHostArgc();
    char **argv = nn::os::GetHostArgv();
    ::testing::InitGoogleTest(&argc, argv);
    nnt::lcs::Parse(&config, setting, argc, argv);

    // socket ライブラリと ns ライブラリを初期化しておきます。
    nn::socket::Initialize(g_SocketConfig);
    nnt::lcs::NsInitializer nsInitiailzer;

    // テストの準備です。
    nnt::lcs::Setup(config.sceneId);

    // テストを実行します。
    g_pHelper = new nnt::lcs::TestHelper(config, "nnt::lcs::IntegrationFork");
    int exitCode = RUN_ALL_TESTS();
    delete g_pHelper;

    // 終了処理です。
    nn::socket::Finalize();
    nnt::Exit(exitCode);
}
