﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/lcs.h>
#include <nn/lcs/lcs_DebugApi.h>
#include <nn/lcs/lcs_PrivateDebugApi.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/socket.h>
#include <nnt.h>
#include <nnt/lcs/testLcs_Utility.h>
#include <nnt/ldn/testLdn_HtcsSynchronization.h>
#include <nnt/ldn/testLdn_NifmUtility.h>
#include <nnt/ldn/testLdn_Utility.h>
#include <nnt/result/testResult_Assert.h>
#include "Precondition.h"

namespace
{
    // テストを実行するヘルパです。
    nnt::lcs::TestHelper* g_pHelper;

    // Socket の初期化用バッファです。
    nn::socket::ConfigDefaultWithMemory g_SocketConfig;

} // namespace <unnamed>

//
// マスターのみが ExFAT ドライバを所有している場合のテストです。
// パッチの Required System Version を契機として LUP が走ります。
//
TEST(MasterHasExFat, PatchRequiredSystemVersion)
{
    const auto cond = GetPrecondition(
        "MasterHasExFat", "PatchRequiredSystemVersion",
        nnt::lcs::Application::ExFat01);
    g_pHelper->RunTest(cond, "MasterHasExFat.PatchRequiredSystemVersion", 2);
}

//
// 特定のスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Required System Version を契機として LUP が走ります。
//
TEST(MasterHasExFat, LcsRequiredSystemVersion)
{
    const auto cond = GetPrecondition(
        "MasterHasExFat", "LcsRequiredSystemVersion",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "MasterHasExFat.LcsRequiredSystemVersion", 2);
}

//
// 特定のスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走ります。
//
TEST(MasterHasExFat, ApplicationDeliveryProtocol)
{
    const auto cond = GetPrecondition(
        "MasterHasExFat", "ApplicationDeliveryProtocol",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "MasterHasExFat.ApplicationDeliveryProtocol", 3);
}

//
// 全端末が ExFAT ドライバを所有している場合のテストです。
// パッチの Required System Version を契機として LUP が走ります。
//
TEST(EveryoneHasExFat, PatchRequiredSystemVersion)
{
    const auto cond = GetPrecondition(
        "EveryoneHasExFat", "PatchRequiredSystemVersion",
        nnt::lcs::Application::ExFat01);
    g_pHelper->RunTest(cond, "EveryoneHasExFat.PatchRequiredSystemVersion", 2);
}

//
// 全端末が ExFAT ドライバを所有している場合のテストです。
// システムの Required System Version を契機として LUP が走ります。
//
TEST(EveryoneHasExFat, LcsRequiredSystemVersion)
{
    const auto cond = GetPrecondition(
        "EveryoneHasExFat", "LcsRequiredSystemVersion",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "EveryoneHasExFat.LcsRequiredSystemVersion", 3);
}

//
// 全端末が ExFAT ドライバを所有している場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走ります。
//
TEST(EveryoneHasExFat, ApplicationDeliveryProtocol)
{
    const auto cond = GetPrecondition(
        "EveryoneHasExFat", "ApplicationDeliveryProtocol",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "EveryoneHasExFat.ApplicationDeliveryProtocol", 3);
}

//
// 全端末が ExFAT ドライバを所有していない場合のテストです。
// パッチの Required System Version を契機として LUP が走ります。
//
TEST(NoOneHasExFat, PatchRequiredSystemVersion)
{
    const auto cond = GetPrecondition(
        "NoOneHasExFat", "PatchRequiredSystemVersion",
        nnt::lcs::Application::ExFat01);
    g_pHelper->RunTest(cond, "NoOneHasExFat.PatchRequiredSystemVersion", 2);
}

//
// 全端末が ExFAT ドライバを所有していない場合のテストです。
// システムの Required System Version を契機として LUP が走ります。
//
TEST(NoOneHasExFat, LcsRequiredSystemVersion)
{
    const auto cond = GetPrecondition(
        "NoOneHasExFat", "LcsRequiredSystemVersion",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "NoOneHasExFat.LcsRequiredSystemVersion", 3);
}

//
// 全端末が ExFAT ドライバを所有していない場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走ります。
//
TEST(NoOneHasExFat, ApplicationDeliveryProtocol)
{
    const auto cond = GetPrecondition(
        "NoOneHasExFat", "ApplicationDeliveryProtocol",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "NoOneHasExFat.ApplicationDeliveryProtocol", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// パッチの Required System Version を契機として LUP が走りますが失敗します。
// ただし、LUP できない端末は必須端末でないため残った端末では成功扱いになります。
//
TEST(SlaveHasExFat, PatchRequiredSystemVersion1)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "PatchRequiredSystemVersion1",
        nnt::lcs::Application::ExFat01);
    g_pHelper->RunTest(cond, "SlaveHasExFat.PatchRequiredSystemVersion1", 2);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// パッチの Required System Version を契機として LUP が走りますが失敗し、
// 残った端末の間でだけローカルパッチ配信が走ります。
//
TEST(SlaveHasExFat, PatchRequiredSystemVersion2)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "PatchRequiredSystemVersion2",
        nnt::lcs::Application::ExFat01);
    g_pHelper->RunTest(cond, "SlaveHasExFat.PatchRequiredSystemVersion2", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// パッチの Required System Version を契機として LUP が走りますが失敗し、
// 残った端末の間でだけ LUP とローカルパッチ配信が走ります。
//
TEST(SlaveHasExFat, PatchRequiredSystemVersion3)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "PatchRequiredSystemVersion3",
        nnt::lcs::Application::ExFat01);
    g_pHelper->RunTest(cond, "SlaveHasExFat.PatchRequiredSystemVersion3", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Required System Version を契機として LUP が走りますが失敗します。
// ただし、LUP できない端末は必須端末でないため残った端末では成功扱いになります。
//
TEST(SlaveHasExFat, LcsRequiredSystemVersion1)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "LcsRequiredSystemVersion1",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.LcsRequiredSystemVersion1", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Required System Version を契機として LUP が走りますが失敗し、
// 残った端末の間でだけローカルパッチ配信が走ります。
//
TEST(SlaveHasExFat, LcsRequiredSystemVersion2)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "LcsRequiredSystemVersion2",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.LcsRequiredSystemVersion2", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Required System Version を契機として LUP が走りますが失敗し、
// 残った端末の間でだけ LUP とローカルパッチ配信が走ります。
//
TEST(SlaveHasExFat, LcsRequiredSystemVersion3)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "LcsRequiredSystemVersion3",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.LcsRequiredSystemVersion3", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Required System Version を契機として LUP が走りますが失敗します。
//
TEST(SlaveHasExFat, LcsRequiredSystemVersion4)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "LcsRequiredSystemVersion4",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.LcsRequiredSystemVersion4", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走りますが失敗します。
// ただし、LUP できない端末は必須端末でないため残った端末では成功扱いになります。
//
TEST(SlaveHasExFat, ApplicationDeliveryProtocol1)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "ApplicationDeliveryProtocol1",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.ApplicationDeliveryProtocol1", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走りますが失敗し、
// 残った端末の間でだけローカルパッチ配信が走ります。
//
TEST(SlaveHasExFat, ApplicationDeliveryProtocol2)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "ApplicationDeliveryProtocol2",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.ApplicationDeliveryProtocol2", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走りますが失敗し、
// 残った端末の間でだけ LUP とローカルパッチ配信が走ります。
//
TEST(SlaveHasExFat, ApplicationDeliveryProtocol3)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "ApplicationDeliveryProtocol3",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.ApplicationDeliveryProtocol3", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システムの Application Delivery Protocol Version を契機として LUP が走りますが失敗します。
//
TEST(SlaveHasExFat, ApplicationDeliveryProtocol4)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "ApplicationDeliveryProtocol4",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.ApplicationDeliveryProtocol4", 3);
}

//
// システムが古いスレーブのみが ExFAT ドライバを所有している場合のテストです。
// システム配信が必要なければパッチ配信は問題なく実行できます。
//
TEST(SlaveHasExFat, PatchShare)
{
    const auto cond = GetPrecondition(
        "SlaveHasExFat", "PatchShare",
        nnt::lcs::Application::ExFat02);
    g_pHelper->RunTest(cond, "SlaveHasExFat.PatchShare", 2);
}

//
// テストのエントリポイントです。
//
extern "C" void nnMain()
{
    // コマンドライン引数に関する設定です。
    nnt::lcs::CommandLineParserSetting setting = { };
    setting.flag = static_cast<nn::Bit32>(
        nnt::lcs::CommandLineOptionFlag_NodeCount |
        nnt::lcs::CommandLineOptionFlag_NodeIndex |
        nnt::lcs::CommandLineOptionFlag_Resume |
        nnt::lcs::CommandLineOptionFlag_SceneId);
    setting.nodeCountMin = 2;
    setting.nodeCountMax = nnt::ldn::SynchronizationClientCountMax;

    // コマンドライン引数を解析します。
    nnt::lcs::TestConfig config;
    int argc = nn::os::GetHostArgc();
    char **argv = nn::os::GetHostArgv();
    ::testing::InitGoogleTest(&argc, argv);
    nnt::lcs::Parse(&config, setting, argc, argv);

    // socket ライブラリと ns ライブラリを初期化しておきます。
    nn::socket::Initialize(g_SocketConfig);
    nnt::lcs::NsInitializer nsInitiailzer;

    // テストの準備です。
    nnt::lcs::Setup(config.sceneId);

    // テストを実行します。
    g_pHelper = new nnt::lcs::TestHelper(config, "nnt::lcs::IntegrationExFat");
    int exitCode = RUN_ALL_TESTS();
    delete g_pHelper;

    // 終了処理です。
    nn::socket::Finalize();
    nnt::Exit(exitCode);
}
