﻿# 文字列を値とするファームウェアの設定を 1 つ書き換えるタスクです。
Function SetStringFirmwareDebugCommand($TargetName, $Setting)
{
    PushDevMenuCommandSystem $TargetName "debug" "set-string-fwdbg"`
        "--name" $($Setting.name)`
        "--key" $($Setting.key)`
        $($Setting.value)
}

# 整数を値とするファームウェアの設定を 1 つ書き換えるタスクです。
Function SetIntegerFirmwareDebugCommand($TargetName, $Setting)
{
    PushDevMenuCommandSystem $TargetName "debug" "set-integer-fwdbg"`
        "--name" $($Setting.name)`
        "--key" $($Setting.key)`
        $($Setting.value)
}

# 真偽値を値とするファームウェアの設定を 1 つ書き換えるタスクです。
Function SetBooleanFirmwareDebugCommand($TargetName, $Setting)
{
    $Value = if ($Setting.value) { "true" } else { "false" }
    PushDevMenuCommandSystem $TargetName "debug" "set-boolean-fwdbg"`
        "--name" $($Setting.name)`
        "--key" $($Setting.key)`
        $Value
}

# ファームウェアの設定を 1 つ書き換えるタスクです。
Function SetFirmwareDebugCommand($TargetName, $Setting)
{
    if ($Setting.value -is [String])
    {
        SetStringFirmwareDebugCommand $TargetName $Setting
    }
    elseif ($Setting.value -is [int])
    {
        SetIntegerFirmwareDebugCommand $TargetName $Setting
    }
    elseif ($Setting.value -is [Boolean])
    {
        SetBooleanFirmwareDebugCommand $TargetName $Setting
    }
    else
    {
        Write-Host "Set Firmware Debug Failure: Unknown Value Type"
    }
}

# ファームウェアの設定をまとめて書き換えるタスクです。
Function SetFirmwareDebugTask($Target, $Settings, $Contents)
{
    foreach ($Setting in $Settings)
    {
        SetFirmwareDebugCommand $Target.Name $Setting
    }
}
