﻿# 指定されたアプリケーションを実行します。
Function RunApplication($Target, $Settings)
{
    # アプリケーションを検索します。
    $Application = $Contents.Applications[$Settings.application]
    if ($Application -eq $NULL)
    {
        throw "Run Failed: Unknown Application = $($Settings.application)"
    }
    
    # メディアによって実行するアプリケーションの指定方法を変更します。
    $Path = $NULL
    if ($Settings.media -eq "gamecard")
    {
        $Path = "gamecard"
    }
    elseif ($Settings.media -eq "nand")
    {
        $Path = $Application.Id
    }
    elseif ($Settings.media -eq "host")
    {
        $Path = (ResolvePath $Application.Path)
    }
    else
    {
        throw "Run Failed: Unknown Media = $($Settings.media)"
    }

    # アプリケーションを実行します。
    if ($Settings.args)
    {
        $Arguments = $Settings.args -split ' '
        Write-Host $RUN_ON_TARGET $Path "-t" $($Target.Name) "--" $Arguments
        &$RUN_ON_TARGET $Path "-t" $($Target.Name) "--" $Arguments > $NULL
    }
    else
    {
        Write-Host $RUN_ON_TARGET $Path "-t" $($Target.Name)
        &$RUN_ON_TARGET $Path "-t" $($Target.Name) > $NULL
    }
}

# 指定されたアプリケーションを実行するタスクです。
Function RunTask($Target, $Settings, $Contents)
{
    foreach ($Setting in $Settings)
    {
        RunApplication $Target $Setting
    }
}
