﻿# ゲームカードに書き込まれたアプリケーションを削除します。
Function EraseGamecard($Target)
{
    DevMenuCommand $Target.Name "gamecard" "erase" > $NULL
}

# ゲームカードにアプリケーションを書き込みます。
Function WriteGamecard($Target, $Application, $Patch)
{
    if ($Patch -eq $NULL)
    {
        DevMenuCommand $Target.Name `
            "gamecard" "write" (ResolvePath $Application.Path) > $NULL
    }
    else
    {
        DevMenuCommand $Target.Name `
            "gamecard" "write" (ResolvePath $Application.Path) `
            "--on-card-patch" (ResolvePath $Patch.Path) > $NULL
    }
}

# ゲームカードに書き込まれたアプリケーションを削除するタスクです。
Function EraseGamecardTask($Target, $Settings, $Contents)
{
    if ($Settings)
    {
        EraseGamecard $Target
    }
}


# ゲームカードにアプリケーションを書き込むタスクです。
Function WriteGamecardTask($Target, $Settings, $Contents)
{
    # アプリケーションを検索します。
    $Application = $Contents.Applications[$Settings.application]
    if ($Application -eq $NULL)
    {
        throw "Write Failed: Unknown Application = $($Settings.application)"
    }

    # パッチを検索します。
    $Patch = $NULL
    if ($Settings.patch)
    {
        $Patch = $Application.Patches[$Settings.patch]
        if ($Patch -eq $NULL)
        {
            throw "Write Failed: Unknown Patch = $($Settings.application) $($Settings.patch)"
        }
    }

    # ゲームカードにアプリケーションを書き込みます。
    WriteGamecard $Target $Application $Patch
}
