﻿# 全タスクをインクルードします。
$MANAGER_SCRIPT_DIR = (Split-Path $($MyInvocation.MyCommand.Path) -Parent)
$TASK_SCRIPT_DIR = "$MANAGER_SCRIPT_DIR\Tasks"
. $TASK_SCRIPT_DIR\DebugCommand
. $TASK_SCRIPT_DIR\ExFat
. $TASK_SCRIPT_DIR\Gamecard
. $TASK_SCRIPT_DIR\Install
. $TASK_SCRIPT_DIR\LocalContentShareDebug
. $TASK_SCRIPT_DIR\Run
. $TASK_SCRIPT_DIR\SaveData
. $TASK_SCRIPT_DIR\Album
. $TASK_SCRIPT_DIR\SetFirmwareDebug
. $TASK_SCRIPT_DIR\Uninstall

# 指定されたタスクリストを実行します。
Function DoTasks($Target, $Tasks, $Contents)
{
    # タスクを順番に処理します。
    foreach ($Key in $Tasks.Keys)
    {
        if ($Key -eq "install")
        {
            InstallTask $Target $($Tasks.install) $Contents
        }
        elseif ($Key -eq "uninstall")
        {
            UninstallTask $Target $($Tasks.uninstall) $Contents
        }
        elseif ($Key -eq "exfat")
        {
            SetExFatEnabledTask $Target $($Tasks.exfat) $Contents
        }
        elseif ($Key -eq "debug")
        {
            ExecuteDebugCommandTask $Target $($Tasks.debug) $Contents
        }
        elseif ($Key -eq "fwdbg")
        {
            SetFirmwareDebugTask $Target $($Tasks.fwdbg) $Contents
        }
        elseif ($Key -eq "localcontentshare")
        {
            ExecuteLocalContentShareDebugCommandTask $Target $($Tasks.localcontentshare) $Contents
        }
        elseif ($Key -eq "erase_gamecard")
        {
            EraseGamecardTask $Target $($Tasks.erase_gamecard) $Contents
        }
        elseif ($Key -eq "write_gamecard")
        {
            WriteGamecardTask $Target $($Tasks.write_gamecard) $Contents
        }
        elseif ($Key -eq "delete_savedata")
        {
            DeleteSavedataTask $Target $($Tasks.delete_savedata) $Contents
        }
        elseif ($Key -eq "clean_album")
        {
            CleanAlbumTask $Target $($Tasks.clean_album) $Contents
        }
        elseif ($Key -eq "run")
        {
            RunTask $Target $($Tasks.run) $Contents
        }
        else
        {
            throw "Unknown Task: $Key"
        }
    }
}

# この開発機がセットアップ対象か否かを判定します。
Function IsSetupTarget($Cond, $Target)
{
    if ($Cond)
    {
        if (,$Cond.index)
        {
            return ($Cond.index -contains $Target.Index)
        }
        elseif (,$Cond.address)
        {
            return ($Cond.address -contains $Target.Address)
        }
        elseif (,$Cond.name)
        {
            return ($Cond.name -contains $Target.Name)
        }
    }
    return $TRUE
}

# 状態定義に基づいて開発機をセットアップします。
Function SetupTarget($Target, $ConfigPaths, $Contents)
{
    # インストール済のアプリケーションを取得しておきます。
    $Target.InstalledApplications = [System.Collections.Generic.List[object]] @(GetInstalledApplicationList $Target.Name)
    $Target.InstalledSystemPrograms = [System.Collections.Generic.List[object]] @(GetInstalledSystemProgramList $Target.Name)

    foreach ($ConfigPath in $ConfigPaths)
    {
        # JSON ファイルを解析します。
        $Json = (ReadJson $ConfigPath)

        # 状態定義を全て順番に処理します。
        foreach ($Def in $Json)
        {
            if (IsSetupTarget $Def.targets $Target)
            {
                if ($Def.tasks)
                {
                    DoTasks $Target $Def.tasks $Contents
                }
            }
        }
    }

    # 高速化のため DevMenuCommand / DevMenuCommandSystem はまとめて実行します。
    DevMenuCommandBatch $Target.Name > $NULL
    DevMenuCommandSystemBatch $Target.Name > $NULL

    # 設定を反映するため、開発機を再起動して接続します。
    ResetTarget $Target.Name
    ConnectToTarget $Target.Name
}
