﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/lcs_PrivateDebugApi.h>
#include <nnt/nntest.h>
#include <nnt/lcs/testLcs_Setup.h>
#include <nnt/ldn/testLdn_NifmUtility.h>

namespace nnt { namespace lcs { namespace
{
    void ValidateConfig(
        const nn::lcs::Config& config, const char* name) NN_NOEXCEPT
    {
        char buffer[nn::lcs::UserNameBytesMax + 1];
        size_t size;
        config.GetName(buffer, &size, sizeof(buffer));
        ASSERT_STREQ(name, buffer);
    }

}}} // namespace nnt::lcs::<unnamed>

namespace nnt { namespace lcs
{
    void Setup(uint16_t sceneId) NN_NOEXCEPT
    {
        //フライトモードをオフにします。
        nnt::ldn::NifmInitializer nifmInitializer;
        nnt::ldn::SetWirelessCommunicationSwitch(true);

        // ローカル通信識別子とシーン識別子を設定しておきます。
        nn::lcs::SetLocalCommunicationId(nn::ldn::DefaultLocalCommunicationId);
        nn::lcs::SetSceneId(sceneId);
    }

    nn::lcs::Config CreateConfig(const char* name) NN_NOEXCEPT
    {
        nn::lcs::Config config;
        config.SetName(name);
        ValidateConfig(config, name);
        return config;
    }

    nn::lcs::Config CreateDefaultHostConfig() NN_NOEXCEPT
    {
        return CreateConfig(DefaultHostUserName);
    }

    nn::lcs::Config CreateDefaultClientConfig() NN_NOEXCEPT
    {
        return CreateConfig(DefaultClientUserName);
    }

    nn::lcs::SessionSettings CreateSessionSettings(
        int nodeCountMax, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    {
        nn::lcs::SessionSettings settings;
        settings.applicationCount = 1;
        settings.contentsShareVersionPolicy = nn::lcs::ContentsShareVersionPolicy_Latest;
        settings.nodeCountMax = static_cast<int8_t>(nodeCountMax);
        settings.applications[0] = applicationId;
        return settings;
    }

    nn::lcs::SessionSettings CreateSessionSettings(
        int nodeCountMax, uint64_t applicationId) NN_NOEXCEPT
    {
        nn::ncm::ApplicationId id = { applicationId };
        return CreateSessionSettings(nodeCountMax, id);
    }

}} // namespace nnt::lcs
