﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/lcs_DebugApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nnt/lcs/testLcs_Initializer.h>
#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

namespace nnt { namespace lcs { namespace
{
    void InitializeImpl(
        void* buffer, size_t bufferSize, const nn::lcs::Config& config) NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::lcs::Initialize(buffer, bufferSize, config));
        ASSERT_EQ(nn::lcs::State_Initialized, nn::lcs::GetState());
    }

    void FinalizeImpl() NN_NOEXCEPT
    {
        nn::lcs::Finalize();
        ASSERT_EQ(nn::lcs::State_None, nn::lcs::GetState());
    }

    void StartHost(const nn::lcs::SessionSettings& settings) NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::lcs::OpenSession(settings));
        ASSERT_EQ(nn::lcs::State_Opened, nn::lcs::GetState());
    }

    void StopHost() NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::lcs::LeaveSession());
        ASSERT_EQ(nn::lcs::State_Initialized, nn::lcs::GetState());
    }

}}} // namespace nnt::lcs::<unnamed>

namespace nnt { namespace lcs
{
    Initializer::Initializer(
        void* buffer, size_t bufferSize, const nn::lcs::Config& config) NN_NOEXCEPT
    {
        InitializeImpl(buffer, bufferSize, config);
    }

    Initializer::~Initializer() NN_NOEXCEPT
    {
        FinalizeImpl();
    }

    NsInitializer::NsInitializer() NN_NOEXCEPT
    {
        nn::ns::Initialize();
    }

    NsInitializer::~NsInitializer() NN_NOEXCEPT
    {
        nn::ns::Finalize();
    }

    HostStarter::HostStarter(const nn::lcs::SessionSettings& settings) NN_NOEXCEPT
    {
        StartHost(settings);
    }

    HostStarter::~HostStarter() NN_NOEXCEPT
    {
        StopHost();
    }

    ProtocolVersionSetter::ProtocolVersionSetter(int major, int minor) NN_NOEXCEPT
        : m_Major(nn::lcs::GetMajorVersion()),
          m_Minor(nn::lcs::GetMinorVersion())
    {
        nn::lcs::SetMajorVersion(major);
        nn::lcs::SetMinorVersion(minor);
    }

    ProtocolVersionSetter::~ProtocolVersionSetter() NN_NOEXCEPT
    {
        nn::lcs::SetMajorVersion(m_Major);
        nn::lcs::SetMinorVersion(m_Minor);
    }

}} // namespace nnt::lcs
