﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs.h>
#include <nnt.h>
#include <nnt/lcs/testLcs_Assert.h>

#define NN_LCS_TO_STRING_CASE(e) case (e): return #e

namespace nn { namespace lcs { namespace
{

    const char* ToString(State state)
    {
        switch (state)
        {
        NN_LCS_TO_STRING_CASE(nn::lcs::State_None);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_Initialized);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_Opened);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_Joined);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_Transferring);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_ContentsShareFailed);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_Suspended);
        NN_LCS_TO_STRING_CASE(nn::lcs::State_Completed);
        default:
            return "<invalid>";
        }
    }

    const char* ToString(ContentsShareFailureReason failureReason)
    {
        switch (failureReason)
        {
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_None);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_FlightMode);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_Sleep);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_CommunicationError);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_NodeLeaved);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_ContentsCorrupted);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_BuiltInStorageError);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_UnknownError);
        NN_LCS_TO_STRING_CASE(nn::lcs::ContentsShareFailureReason_UnshareableContents);
        default:
            return "<invalid>";
        }
    }

    const char* ToString(SuspendedReason suspendedReason)
    {
        switch (suspendedReason)
        {
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_None);
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_IncompatibleContentsInfo);
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_NeedTerminateApplication);
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_EulaRequired);
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_RebootRequired);
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_StorageSpaceNotEnough);
        NN_LCS_TO_STRING_CASE(nn::lcs::SuspendedReason_StorageSpaceNotEnoughOnRequredNode);
        default:
            return "<invalid>";
        }
    }

}}} // namespace nn::lcs::<unnamed>

namespace nn { namespace lcs
{

    void PrintTo(const nn::lcs::State& state, ::nnt::testing::detail::StringStream* os)
    {
        *os << state << " (" << ToString(state);

        if (state == State_ContentsShareFailed)
        {
            *os << " , reason: ";
            PrintTo(GetContentsShareFailureReason(), os);
        }
        else if (state == State_Suspended)
        {
            *os << " , reason: ";
            PrintTo(GetSuspendedReason(), os);
        }

        *os << ")";
    }

    void PrintTo(const nn::lcs::ContentsShareFailureReason& failureReason, ::nnt::testing::detail::StringStream* os)
    {
        *os << failureReason << " (" << ToString(failureReason) << ")";
    }

    void PrintTo(const nn::lcs::SuspendedReason& suspenedReason, ::nnt::testing::detail::StringStream* os)
    {
        *os << suspenedReason << " (" << ToString(suspenedReason) << ")";
    }

}} // namespace nn::lcs
