﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nnt/nntest.h>
#include <nn/nn_TimeSpan.h>

#include "testLbl_Util-hardware.nx.h"
#include "testLbl_Helper.h"
#include "testLbl_Config.h"

namespace nnt { namespace lbl {

void SetUniformedValueToSetting(float value) NN_NOEXCEPT
{
    lbldfc::SetCurrentBrightnessSetting(value);
    lbldfc::SetCurrentBrightnessSettingForVrMode(value);
    lbldfc::SetAmbientLightSensorValue(value);
}

void SetMaxValueToSetting() NN_NOEXCEPT
{
    lbldfc::SetCurrentBrightnessSetting(std::numeric_limits<float>::max());
    lbldfc::SetCurrentBrightnessSettingForVrMode(std::numeric_limits<float>::max());
    lbldfc::SetAmbientLightSensorValue(std::numeric_limits<float>::max());
    lbldfc::SwitchBacklightOn(nn::TimeSpan::FromNanoSeconds(std::numeric_limits<int64_t>::max()));
    lbldfc::SwitchBacklightOff(nn::TimeSpan::FromNanoSeconds(std::numeric_limits<int64_t>::max()));
}

void SetMinValueToSetting() NN_NOEXCEPT
{
    lbldfc::SetCurrentBrightnessSetting(0.0f);
    lbldfc::SetCurrentBrightnessSettingForVrMode(0.0f);
    lbldfc::SetAmbientLightSensorValue(0.0f);
    lbldfc::SwitchBacklightOn(nn::TimeSpan::FromNanoSeconds(0LL));
    lbldfc::SwitchBacklightOff(nn::TimeSpan::FromNanoSeconds(0LL));
}

float GetStableAutoAppliedBrightnessSetting(float brightness, float sensor) NN_NOEXCEPT
{
    lbldfc::SetCurrentBrightnessSetting(brightness);
    lbldfc::SetAmbientLightSensorValue(sensor);

    // 5秒分輝度を更新して、輝度値を安定させる。
    for (int i1=0; i1<300; ++i1)
    {
        lbldfc::ApplyCurrentBrightnessSettingToBacklight();
    }
    float appliedBrightness = lbldfc::GetBrightnessSettingAppliedToBacklight();
    return appliedBrightness;
}

LblInitializer::LblInitializer()
{
    // DFC時の初期化とHIPC時の初期化は異なる点だけ注意。
    lbldfc::Initialize();

    // テスト時の内部変数の値を割り当て(NANDには書き込まない)。
    lbldfc::DisableDimming();
    lbldfc::DisableVrMode();
    lbldfc::DisableAutoBrightnessControl();
    lbldfc::SetCurrentBrightnessSetting(1.0f);
    lbldfc::SetCurrentBrightnessSettingForVrMode(1.0f);
    lbldfc::SetAmbientLightSensorValue(0.0f);
    //nn::lbl::impl::SaveCurrentSetting();

    // 点灯状態からテストを開始する。
    lbldfc::SwitchBacklightOn(0);
    lbldfc::ApplyCurrentBrightnessSettingToBacklight();
}

LblInitializer::~LblInitializer()
{
    // 終了処理が本当に必要なのはDFCで動かすときのみ。
    lbldfc::Finalize();
}

}}  // namespace nnt::lbl
