﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_TimeSpan.h>
#include <nn/lbl/lbl_Type.h>
#include <nn/lbl/lbl_Control.h>
#include <nn/lbl/lbl_Settings.h>
#include <nn/pwm/pwm.h>
#include <nn/gpio/gpio.h>
#include <nn/settings/system/settings_Backlight.h>

// フェイク環境でしかテストできないテストケースためのマクロ。
#if defined(NN_BUILD_CONFIG_OS_WIN32)
#define FAKE_ENV_TEST(target) target
#else
#define FAKE_ENV_TEST(target)   // Do nothing.
#endif

// 関数実行後に輝度設定値をバックライトに適用するためのマクロ。
#define APPLY_BRIGHTNESS_SETTING(func) func; lbldfc::ApplyCurrentBrightnessSettingToBacklight()

namespace nnt { namespace lbl {

const float Coefficients[][nn::lbl::CoefficentCountMax] =
{
    {0.0f, 0.0f, 0.0f},
    {std::numeric_limits<float>::lowest(), std::numeric_limits<float>::lowest(), std::numeric_limits<float>::lowest()},
    {std::numeric_limits<float>::max(), std::numeric_limits<float>::max(), std::numeric_limits<float>::max()},
};
const float MinManualControlBrightness = 0.063f;

}}
