﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <memory>

#include "TestVm.h"

namespace nn { namespace jit { namespace testvm {

class JitRunner
{
private:

    MachineContext* m_pContext;

    struct Info
    {
        void* f = nullptr;
    };

    std::unique_ptr<Info[]> m_Infos;

private:

    int32_t Pop() NN_NOEXCEPT;
    void Push(int32_t) NN_NOEXCEPT;
    void Jump(int32_t pc) NN_NOEXCEPT;
    void JumpRelative(int32_t d) NN_NOEXCEPT;

    // pure
    virtual void* GenerateCode(size_t* pByteSize, uint32_t* pInstructionCount, int32_t pc) NN_NOEXCEPT = 0;

protected:

    explicit JitRunner(MachineContext* pContext) NN_NOEXCEPT;
    const MachineContext* GetMachineContext() const NN_NOEXCEPT
    {
        return m_pContext;
    }

public:

    void Run() NN_NOEXCEPT;

    static void GenerateCodeImpl(size_t* pByteSize, uint32_t* pInstructionCount, char* buffer, const Instruction* instructions, int32_t pc) NN_NOEXCEPT;
    void GenerateCodeImpl(size_t* pByteSize, uint32_t* pInstructionCount, char* buffer, int32_t pc) NN_NOEXCEPT;

};

}}}
