﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/svc/svc_Base.h>

namespace nn { namespace jit {

svc::Handle DuplicateHandle(svc::Handle handle) NN_NOEXCEPT;

class AslrAllocator
{
public:
    NN_IMPLICIT AslrAllocator(nn::svc::Handle process) NN_NOEXCEPT;
    uint64_t GetAslrRegion(uint64_t mappingSize) NN_NOEXCEPT;
private:
    uint64_t m_HeapBegin;
    uint64_t m_HeapSize;
    uint64_t m_RsvBegin;
    uint64_t m_RsvSize;
    uint64_t m_AslrBegin;
    uint64_t m_AslrSize;
};

void StoreDataCacheAndMemoryBarrier(uintptr_t addr, size_t size) NN_NOEXCEPT;
void InvalidateInstructionCacheAndMemoryBarrier(uintptr_t addr, size_t size) NN_NOEXCEPT;

}}
