﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "TestVm.h"

namespace nn { namespace jit { namespace testvm {

class Interpreter
{
private:

    MachineContext* m_pContext;

public:

    explicit Interpreter(MachineContext* pContext) NN_NOEXCEPT
        : m_pContext(pContext)
    {
    }

    bool Step1() NN_NOEXCEPT;
    void Run() NN_NOEXCEPT;

private:

    int32_t Pop() NN_NOEXCEPT;
    void Push(int32_t) NN_NOEXCEPT;
    void Jump(int32_t pc) NN_NOEXCEPT;
    void JumpRelative(int32_t d) NN_NOEXCEPT;

};

void RunTestVmByInterpreter(MachineContext*) NN_NOEXCEPT;

}}}
