﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/hid.h>
#include <nn/hid/hid_NpadJoy.h>

#include "GraphicsSystem.h"
#include "AttachmentDataFormat.h"

class SceneBase
{
    NN_DISALLOW_COPY(SceneBase);
    NN_DISALLOW_MOVE(SceneBase);

public:
    SceneBase(){}
    virtual ~SceneBase() {}

public:
    void Initialize(
        nn::hid::NpadIdType id,
        GraphicsSystem* pGraphicsSystem,
        void* pImageTransferWorkMemory);
    void Finalize();
    void Update() NN_NOEXCEPT;
    void Draw() NN_NOEXCEPT;

protected:
    int GetMenuIndex() const;

    virtual void DoInitialize(){}
    virtual void DoFinalize(){}
    virtual void DoUpdate(){}
    virtual void DoDraw(){}

protected:
    nn::hid::NpadIdType              m_NpadId;
    int                              m_MenuSelection{};
    nn::hid::NpadJoyDualState        m_PreviousPadState{};
    GraphicsSystem*                  m_pGraphicsSystem;
    void*                            m_pImageBuffer;
};
