﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/hid.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/irsensor.h>

#include "GraphicsSystem.h"
#include "SceneBase.h"
#include "ReflectionCheckerView.h"

class ReflectionCheckerScene : public SceneBase
{
    NN_DISALLOW_COPY(ReflectionCheckerScene);
    NN_DISALLOW_MOVE(ReflectionCheckerScene);

public:
    ReflectionCheckerScene();
    virtual ~ReflectionCheckerScene();

private:
    bool ProcessHidInput() NN_NOEXCEPT;

public:
    virtual void DoInitialize();
    virtual void DoFinalize();
    virtual void DoUpdate() NN_NOEXCEPT;
    virtual void DoDraw() NN_NOEXCEPT;

    bool IsFrameCaptured();
    void CaptureFrame();

private:
    int m_Cursor;
    ReflectionCheckerView m_View;
};
