﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


// NintendoSDK のヘッダファイルをインクルードする前に、NN_GFX_UTIL_DEBUGFONT_USE_DEFAULT_LOCALE_CHARSET マクロを
// 定義することで、DebugFontWriter::Print() の入力文字コードを Windows のロケールのデフォルト
// (日本語の場合、CP932)に変更できます。
//#define NN_GFX_UTIL_DEBUGFONT_USE_DEFAULT_LOCALE_CHARSET

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/irsensor.h>
#include <nns/gfx/gfx_GraphicsFramework.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/init/init_Malloc.h>

#include "GraphicsSystem.h"
#include "ImageTransferModeState.h"
#include "AttachmentDataFormat.h"
#include "ReflectionCheckerScene.h"
#include "SceneBase.h"

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
#include <nv/nv_MemoryManagement.h>
#endif

namespace {

const int FrameRate = 60;

}

extern "C" void nnMain()
{
    /////////////////////////////////////////////////////////////////
    // Initialization
    /////////////////////////////////////////////////////////////////

    nn::hid::NpadIdType npadIds[] =
    {
        ::nn::hid::NpadId::No1,
    };

    //
    // Memory
    //

    nn::mem::StandardAllocator appAllocator;
    void* workMemoryBuffers[NN_ARRAY_SIZE(npadIds)];
    const size_t appMemorySize  = 128 * 1024 * 1014;
    nn::Bit8* pAppMemory        = new nn::Bit8[appMemorySize];

    appAllocator.Initialize(pAppMemory, appMemorySize);


#if defined(NN_BUILD_TARGET_PLATFORM_NX)
    const size_t graphicsMemorySize = 8 * 1024 * 1024;
    void* pGraphicsMemory = nns::gfx::GraphicsFramework::DefaultAllocateFunction(graphicsMemorySize, 1, nullptr);
    nv::SetGraphicsAllocator(nns::gfx::GraphicsFramework::DefaultAllocateFunction, nns::gfx::GraphicsFramework::DefaultFreeFunction, nns::gfx::GraphicsFramework::DefaultReallocateFunction, nullptr);
    nv::SetGraphicsDevtoolsAllocator(nns::gfx::GraphicsFramework::DefaultAllocateFunction, nns::gfx::GraphicsFramework::DefaultFreeFunction, nns::gfx::GraphicsFramework::DefaultReallocateFunction, nullptr);
    nv::InitializeGraphics(pGraphicsMemory, graphicsMemorySize);
#endif

    //
    // Graphics
    //

    GraphicsSystem* pGraphicsSystem = new ::GraphicsSystem();
    pGraphicsSystem->SetApplicationHeap(&appAllocator);
    pGraphicsSystem->Initialize();

    //
    // Initialize Hid
    //
    nn::hid::InitializeNpad();
    nn::hid::SetSupportedNpadStyleSet(::nn::hid::NpadStyleJoyDual::Mask);
    nn::hid::SetSupportedNpadIdType(npadIds, NN_ARRAY_SIZE(npadIds));

    //
    // Initialize Scene
    //
    const int SceneMaxCount = 1;
    ReflectionCheckerScene evalScene[SceneMaxCount];

    for (int i = 0; i < SceneMaxCount; i++)
    {
        workMemoryBuffers[i] = appAllocator.Allocate(ImageTransferModeState::WorkMemorySize, ImageTransferModeState::WorkMemoryAlignement);
        SceneBase* pScene = &evalScene[i];
        pScene->Initialize(npadIds[i], pGraphicsSystem, workMemoryBuffers[i]);
    }

    /////////////////////////////////////////////////////////////////
    // Main Loop
    /////////////////////////////////////////////////////////////////

    bool exit = false;
    while (!exit)
    {
        // Update
        for (auto i = 0; i < SceneMaxCount; i++)
        {
            SceneBase* pScene = &evalScene[i];
            pScene->Update();
            //if (false)
            //{
            //    exit = true;
            //}
        }

        // Draw
        nn::gfx::util::DebugFontTextWriter* pTextWriter = &pGraphicsSystem->GetDebugFont();
        pGraphicsSystem->BeginDraw();

        for (auto i = 0; i < SceneMaxCount; ++i)
        {
            SceneBase* pScene = &evalScene[i];
            pScene->Draw();
        }
        pTextWriter->Draw(&pGraphicsSystem->GetCommandBuffer());

        pGraphicsSystem->EndDraw();
        pGraphicsSystem->Synchronize(
            nn::TimeSpan::FromNanoSeconds(1000 * 1000 * 1000 / FrameRate));
    }
    /////////////////////////////////////////////////////////////////
    // Finalization
    /////////////////////////////////////////////////////////////////

    //
    // Finalize Demo
    //
    for (int i = 0; i < SceneMaxCount; ++i)
    {
        SceneBase* pScene = &evalScene[i];
        pScene->Finalize();
        appAllocator.Free(workMemoryBuffers[i]);
    }

    //
    // Finalize Graphics
    //

    pGraphicsSystem->Finalize();
    delete pGraphicsSystem;

    //
    // Finalize Memory
    //
    appAllocator.Finalize();
    delete[] pAppMemory;
}//NOLINT(readability/fn_size)
