﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/irsensor.h>
#include <nnt/nntest.h>

TEST(Smoke, InitializeWithNpadId)
{
    nn::hid::NpadIdType npadIds[] = {
        nn::hid::NpadId::No1,
        nn::hid::NpadId::No2,
        nn::hid::NpadId::No3,
        nn::hid::NpadId::No4,
        nn::hid::NpadId::No5,
        nn::hid::NpadId::No6,
        nn::hid::NpadId::No7,
        nn::hid::NpadId::No8,
        nn::hid::NpadId::Handheld,
        // nn::hid::system::NpadSystemId::Other,
    };

    const int NpadIdCountMax = sizeof(npadIds) / sizeof(npadIds[0]);

    nn::hid::InitializeNpad();

    nn::hid::SetSupportedNpadIdType(npadIds, NpadIdCountMax);
    for (auto i = 0; i < NpadIdCountMax; ++i)
    {
        auto handle = ::nn::irsensor::GetIrCameraHandle(npadIds[i]);
        ::nn::irsensor::Initialize(handle);
        ::nn::irsensor::Finalize(handle);
    }
}
