﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Thread.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/irsensor.h>
#include <nnt.h>

namespace nnt { namespace irsensor {

#if defined(NN_BUILD_CONFIG_OS_WIN32)
#define NNT_IRSENSOR_EXIT_0 ::testing::ExitedWithCode(0)
#define NNT_IRSENSOR_EXIT_SUCCESS exit(0)
#define NNT_IRSENSOR_EXPECT_EXIT(statement, predicate, regex) EXPECT_EXIT(statement, predicate, regex)
#else
#define NNT_IRSENSOR_EXIT_SUCCESS /* 何もしない */
#define NNT_IRSENSOR_EXPECT_EXIT(statement, predicate, regex) statement
#endif

namespace
{
    nn::hid::NpadIdType g_NpadIds[] = {
        nn::hid::NpadId::No1,
        nn::hid::NpadId::No2,
        nn::hid::NpadId::No3,
        nn::hid::NpadId::No4,
    };

    const int NpadIdCountMax = sizeof(g_NpadIds) / sizeof(g_NpadIds[0]);
}

class IrSensorTest : public ::testing::Test
{
protected:
    virtual void SetUp() NN_NOEXCEPT
    {
        nn::hid::InitializeNpad();

        s_HandleCount = NpadIdCountMax;
        // RightJoy のみ使用するモードに設定
        nn::hid::SetSupportedNpadStyleSet(nn::hid::NpadStyleJoyRight::Mask);

        nn::hid::SetSupportedNpadIdType(g_NpadIds, NpadIdCountMax);
        for (auto i = 0; i < s_HandleCount; ++i)
        {
            auto id = g_NpadIds[i];
            s_Handles[i] = ::nn::irsensor::GetIrCameraHandle(id);
            ::nn::irsensor::Initialize(s_Handles[i]);
        }
    }

    virtual void TearDown() NN_NOEXCEPT
    {
        for (auto i = 0; i < s_HandleCount; ++i)
        {
            ::nn::irsensor::Finalize(s_Handles[i]);
        }
    }

protected:
    // specs=NX のときに Typed Test がメンバにアクセスできないので
    // 静的変数にしてアクセスできるようにする
    static ::nn::irsensor::IrCameraHandle s_Handles[NpadIdCountMax];
    static int s_HandleCount;
};

template <typename T, int N>
inline int GetArrayLength(T (&)[N]) NN_NOEXCEPT
{
    return N;
}

inline void WaitForReceivingStates()
{
    const auto SleepTimeMilliseconds = 1000;
    ::nn::os::SleepThread(::nn::TimeSpan::FromMilliSeconds(SleepTimeMilliseconds));
}

}} // namaspace nnt::irsensor
